/*
 * Decompiled with CFR 0.152.
 */
package net.brunomendola.querity.test;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.brunomendola.querity.api.Condition;
import net.brunomendola.querity.api.Operator;
import net.brunomendola.querity.api.Querity;
import net.brunomendola.querity.api.Query;
import net.brunomendola.querity.api.Sort;
import net.brunomendola.querity.test.CsvUtils;
import net.brunomendola.querity.test.domain.Person;
import net.brunomendola.querity.test.domain.PersonRepository;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.core.GenericTypeResolver;

@SpringBootTest
public abstract class QuerityGenericSpringTestSuite<T extends Person<?>> {
    public final List<T> entities = this.getEntities();
    @Autowired
    PersonRepository<T, ?> repository;
    @Autowired
    Querity querity;

    @BeforeEach
    void setUp() {
        this.repository.saveAll(this.entities);
    }

    @AfterEach
    void tearDown() {
        this.repository.deleteAll();
    }

    @Test
    void givenNullQuery_whenFilterAll_thenReturnAllTheElements() {
        List result = this.querity.findAll(this.getEntityClass(), null);
        Assertions.assertThat((List)result).hasSize(6);
        Assertions.assertThat((List)result).isEqualTo(this.entities);
    }

    @Test
    void givenEmptyFilter_whenFilterAll_thenReturnAllTheElements() {
        Query query = Querity.query().build();
        List result = this.querity.findAll(this.getEntityClass(), query);
        Assertions.assertThat((List)result).hasSize(6);
        Assertions.assertThat((List)result).isEqualTo(this.entities);
    }

    @Test
    void givenFilterWithStringEqualsCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
        Query query = Querity.query().filter((Condition)Querity.filterBy((String)"lastName", (Operator)Operator.EQUALS, (Object)"Skywalker")).build();
        List result = this.querity.findAll(this.getEntityClass(), query);
        Assertions.assertThat((List)result).hasSize(2);
        Assertions.assertThat((List)result).isEqualTo(this.entities.stream().filter(p -> "Skywalker".equals(p.getLastName())).collect(Collectors.toList()));
    }

    @Test
    void givenFilterWithIntegerEqualsCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
        Query query = Querity.query().filter((Condition)Querity.filterBy((String)"children", (Operator)Operator.EQUALS, (Object)2)).build();
        List result = this.querity.findAll(this.getEntityClass(), query);
        Assertions.assertThat((List)result).hasSize(1);
        Assertions.assertThat((List)result).isEqualTo(this.entities.stream().filter(p -> p.getChildren() != null && p.getChildren().equals(2)).collect(Collectors.toList()));
    }

    @Test
    void givenFilterWithIntegerEqualsConditionAsString_whenFilterAll_thenReturnOnlyFilteredElements() {
        Query query = Querity.query().filter((Condition)Querity.filterBy((String)"children", (Operator)Operator.EQUALS, (Object)"2")).build();
        List result = this.querity.findAll(this.getEntityClass(), query);
        Assertions.assertThat((List)result).hasSize(1);
        Assertions.assertThat((List)result).isEqualTo(this.entities.stream().filter(p -> p.getChildren() != null && p.getChildren().equals(2)).collect(Collectors.toList()));
    }

    @Test
    void givenFilterWithBigDecimalEqualsCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
        Query query = Querity.query().filter((Condition)Querity.filterBy((String)"height", (Operator)Operator.EQUALS, (Object)new BigDecimal("1.72"))).build();
        List result = this.querity.findAll(this.getEntityClass(), query);
        Assertions.assertThat((List)result).hasSize(1);
        Assertions.assertThat((List)result).isEqualTo(this.entities.stream().filter(p -> p.getHeight().compareTo(new BigDecimal("1.72")) == 0).collect(Collectors.toList()));
    }

    @Test
    void givenFilterWithBigDecimalEqualsConditionAsString_whenFilterAll_thenReturnOnlyFilteredElements() {
        Query query = Querity.query().filter((Condition)Querity.filterBy((String)"height", (Operator)Operator.EQUALS, (Object)"1.72")).build();
        List result = this.querity.findAll(this.getEntityClass(), query);
        Assertions.assertThat((List)result).hasSize(1);
        Assertions.assertThat((List)result).isEqualTo(this.entities.stream().filter(p -> p.getHeight().compareTo(new BigDecimal("1.72")) == 0).collect(Collectors.toList()));
    }

    @Test
    void givenFilterWithBigDecimalGreaterThanCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
        Query query = Querity.query().filter((Condition)Querity.filterBy((String)"height", (Operator)Operator.GREATER_THAN, (Object)"1.72")).build();
        List result = this.querity.findAll(this.getEntityClass(), query);
        Assertions.assertThat((List)result).hasSize(4);
        Assertions.assertThat((List)result).isEqualTo(this.entities.stream().filter(p -> p.getHeight().compareTo(new BigDecimal("1.72")) > 0).collect(Collectors.toList()));
    }

    @Test
    void givenFilterWithNotBigDecimalGreaterThanCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
        Query query = Querity.query().filter((Condition)Querity.not((Condition)Querity.filterBy((String)"height", (Operator)Operator.GREATER_THAN, (Object)"1.72"))).build();
        List result = this.querity.findAll(this.getEntityClass(), query);
        Assertions.assertThat((List)result).hasSize(2);
        Assertions.assertThat((List)result).isEqualTo(this.entities.stream().filter(p -> p.getHeight().compareTo(new BigDecimal("1.72")) <= 0).collect(Collectors.toList()));
    }

    @Test
    void givenFilterWithBigDecimalGreaterThanEqualsCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
        Query query = Querity.query().filter((Condition)Querity.filterBy((String)"height", (Operator)Operator.GREATER_THAN_EQUALS, (Object)"1.72")).build();
        List result = this.querity.findAll(this.getEntityClass(), query);
        Assertions.assertThat((List)result).hasSize(5);
        Assertions.assertThat((List)result).isEqualTo(this.entities.stream().filter(p -> p.getHeight().compareTo(new BigDecimal("1.72")) >= 0).collect(Collectors.toList()));
    }

    @Test
    void givenFilterWithNotBigDecimalGreaterThanEqualsCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
        Query query = Querity.query().filter((Condition)Querity.not((Condition)Querity.filterBy((String)"height", (Operator)Operator.GREATER_THAN_EQUALS, (Object)"1.72"))).build();
        List result = this.querity.findAll(this.getEntityClass(), query);
        Assertions.assertThat((List)result).hasSize(1);
        Assertions.assertThat((List)result).isEqualTo(this.entities.stream().filter(p -> p.getHeight().compareTo(new BigDecimal("1.72")) < 0).collect(Collectors.toList()));
    }

    @Test
    void givenFilterWithBigDecimalLesserThanCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
        Query query = Querity.query().filter((Condition)Querity.filterBy((String)"height", (Operator)Operator.LESSER_THAN, (Object)"1.72")).build();
        List result = this.querity.findAll(this.getEntityClass(), query);
        Assertions.assertThat((List)result).hasSize(1);
        Assertions.assertThat((List)result).isEqualTo(this.entities.stream().filter(p -> p.getHeight().compareTo(new BigDecimal("1.72")) < 0).collect(Collectors.toList()));
    }

    @Test
    void givenFilterWithNotBigDecimalLesserThanCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
        Query query = Querity.query().filter((Condition)Querity.not((Condition)Querity.filterBy((String)"height", (Operator)Operator.LESSER_THAN, (Object)"1.72"))).build();
        List result = this.querity.findAll(this.getEntityClass(), query);
        Assertions.assertThat((List)result).hasSize(5);
        Assertions.assertThat((List)result).isEqualTo(this.entities.stream().filter(p -> p.getHeight().compareTo(new BigDecimal("1.72")) >= 0).collect(Collectors.toList()));
    }

    @Test
    void givenFilterWithBigDecimalLesserThanEqualsCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
        Query query = Querity.query().filter((Condition)Querity.filterBy((String)"height", (Operator)Operator.LESSER_THAN_EQUALS, (Object)"1.72")).build();
        List result = this.querity.findAll(this.getEntityClass(), query);
        Assertions.assertThat((List)result).hasSize(2);
        Assertions.assertThat((List)result).isEqualTo(this.entities.stream().filter(p -> p.getHeight().compareTo(new BigDecimal("1.72")) <= 0).collect(Collectors.toList()));
    }

    @Test
    void givenFilterWithNotBigDecimalLesserThanEqualsCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
        Query query = Querity.query().filter((Condition)Querity.not((Condition)Querity.filterBy((String)"height", (Operator)Operator.LESSER_THAN_EQUALS, (Object)"1.72"))).build();
        List result = this.querity.findAll(this.getEntityClass(), query);
        Assertions.assertThat((List)result).hasSize(4);
        Assertions.assertThat((List)result).isEqualTo(this.entities.stream().filter(p -> p.getHeight().compareTo(new BigDecimal("1.72")) > 0).collect(Collectors.toList()));
    }

    @Test
    void givenFilterWithStringNotEqualsCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
        Query query = Querity.query().filter((Condition)Querity.filterBy((String)"lastName", (Operator)Operator.NOT_EQUALS, (Object)"Skywalker")).build();
        List result = this.querity.findAll(this.getEntityClass(), query);
        Assertions.assertThat((List)result).hasSize(4);
        Assertions.assertThat((List)result).isEqualTo(this.entities.stream().filter(p -> !"Skywalker".equals(p.getLastName())).collect(Collectors.toList()));
    }

    @Test
    void givenFilterWithNotStringNotEqualsCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
        Query query = Querity.query().filter((Condition)Querity.not((Condition)Querity.filterBy((String)"lastName", (Operator)Operator.NOT_EQUALS, (Object)"Skywalker"))).build();
        List result = this.querity.findAll(this.getEntityClass(), query);
        Assertions.assertThat((List)result).hasSize(2);
        Assertions.assertThat((List)result).isEqualTo(this.entities.stream().filter(p -> "Skywalker".equals(p.getLastName())).collect(Collectors.toList()));
    }

    @Test
    void givenFilterWithStringStartsWithCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
        Query query = Querity.query().filter((Condition)Querity.filterBy((String)"lastName", (Operator)Operator.STARTS_WITH, (Object)"Sky")).build();
        List result = this.querity.findAll(this.getEntityClass(), query);
        Assertions.assertThat((List)result).hasSize(2);
        Assertions.assertThat((List)result).isEqualTo(this.entities.stream().filter(p -> p.getLastName() != null && p.getLastName().startsWith("Sky")).collect(Collectors.toList()));
    }

    @Test
    void givenFilterWithStringEndsWithCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
        Query query = Querity.query().filter((Condition)Querity.filterBy((String)"lastName", (Operator)Operator.ENDS_WITH, (Object)"walker")).build();
        List result = this.querity.findAll(this.getEntityClass(), query);
        Assertions.assertThat((List)result).hasSize(2);
        Assertions.assertThat((List)result).isEqualTo(this.entities.stream().filter(p -> p.getLastName() != null && p.getLastName().endsWith("walker")).collect(Collectors.toList()));
    }

    @Test
    void givenFilterWithStringContainsCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
        Query query = Querity.query().filter((Condition)Querity.filterBy((String)"lastName", (Operator)Operator.CONTAINS, (Object)"walk")).build();
        List result = this.querity.findAll(this.getEntityClass(), query);
        Assertions.assertThat((List)result).hasSize(2);
        Assertions.assertThat((List)result).isEqualTo(this.entities.stream().filter(p -> p.getLastName() != null && p.getLastName().contains("walk")).collect(Collectors.toList()));
    }

    @Test
    void givenFilterWithStringNotContainsCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
        Query query = Querity.query().filter((Condition)Querity.not((Condition)Querity.filterBy((String)"lastName", (Operator)Operator.CONTAINS, (Object)"walk"))).build();
        List result = this.querity.findAll(this.getEntityClass(), query);
        Assertions.assertThat((List)result).hasSize(4);
        Assertions.assertThat((List)result).isEqualTo(this.entities.stream().filter(p -> p.getLastName() == null || !p.getLastName().contains("walk")).collect(Collectors.toList()));
    }

    @Test
    void givenFilterWithStringIsNullCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
        Query query = Querity.query().filter((Condition)Querity.filterBy((String)"lastName", (Operator)Operator.IS_NULL)).build();
        List result = this.querity.findAll(this.getEntityClass(), query);
        Assertions.assertThat((List)result).hasSize(1);
        Assertions.assertThat((List)result).isEqualTo(this.entities.stream().filter(p -> p.getLastName() == null).collect(Collectors.toList()));
    }

    @Test
    void givenFilterWithStringIsNotNullCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
        Query query = Querity.query().filter((Condition)Querity.filterBy((String)"lastName", (Operator)Operator.IS_NOT_NULL)).build();
        List result = this.querity.findAll(this.getEntityClass(), query);
        Assertions.assertThat((List)result).hasSize(5);
        Assertions.assertThat((List)result).isEqualTo(this.entities.stream().filter(p -> p.getLastName() != null).collect(Collectors.toList()));
    }

    @Test
    void givenFilterWithNotStringIsNotNullCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
        Query query = Querity.query().filter((Condition)Querity.not((Condition)Querity.filterBy((String)"lastName", (Operator)Operator.IS_NOT_NULL))).build();
        List result = this.querity.findAll(this.getEntityClass(), query);
        Assertions.assertThat((List)result).hasSize(1);
        Assertions.assertThat((List)result).isEqualTo(this.entities.stream().filter(p -> p.getLastName() == null).collect(Collectors.toList()));
    }

    @Test
    void givenFilterWithTwoStringEqualsConditionsWithAndLogic_whenFilterAll_thenReturnOnlyFilteredElements() {
        Query query = Querity.query().filter((Condition)Querity.and((Condition[])new Condition[]{Querity.filterBy((String)"lastName", (Operator)Operator.EQUALS, (Object)"Skywalker"), Querity.filterBy((String)"firstName", (Operator)Operator.EQUALS, (Object)"Luke")})).build();
        List result = this.querity.findAll(this.getEntityClass(), query);
        Assertions.assertThat((List)result).hasSize(1);
        Assertions.assertThat((List)result).isEqualTo(this.entities.stream().filter(p -> "Skywalker".equals(p.getLastName()) && "Luke".equals(p.getFirstName())).collect(Collectors.toList()));
    }

    @Test
    void givenFilterWithTwoStringEqualsConditionsWithOrLogic_whenFilterAll_thenReturnOnlyFilteredElements() {
        Query query = Querity.query().filter((Condition)Querity.or((Condition[])new Condition[]{Querity.filterBy((String)"lastName", (Operator)Operator.EQUALS, (Object)"Skywalker"), Querity.filterBy((String)"lastName", (Operator)Operator.EQUALS, (Object)"Kenobi")})).build();
        List result = this.querity.findAll(this.getEntityClass(), query);
        Assertions.assertThat((List)result).hasSize(3);
        Assertions.assertThat((List)result).isEqualTo(this.entities.stream().filter(p -> "Skywalker".equals(p.getLastName()) || "Kenobi".equals(p.getLastName())).collect(Collectors.toList()));
    }

    @Test
    void givenFilterWithNestedConditions_whenFindAll_thenReturnListOfEntity() {
        Query query = Querity.query().filter((Condition)Querity.and((Condition[])new Condition[]{Querity.filterBy((String)"lastName", (Operator)Operator.EQUALS, (Object)"Skywalker"), Querity.or((Condition[])new Condition[]{Querity.filterBy((String)"firstName", (Operator)Operator.EQUALS, (Object)"Anakin"), Querity.filterBy((String)"firstName", (Operator)Operator.EQUALS, (Object)"Luke")})})).build();
        List result = this.querity.findAll(this.getEntityClass(), query);
        Assertions.assertThat((List)result).hasSize(2);
        Assertions.assertThat((List)result).isEqualTo(this.entities.stream().filter(p -> "Skywalker".equals(p.getLastName()) && ("Anakin".equals(p.getFirstName()) || "Luke".equals(p.getFirstName()))).collect(Collectors.toList()));
    }

    @Test
    void givenFilterWithStringEqualsConditionOnNestedField_whenFilterAll_thenReturnOnlyFilteredElements() {
        Query query = Querity.query().filter((Condition)Querity.filterBy((String)"address.city", (Operator)Operator.EQUALS, (Object)"Tatooine")).build();
        List result = this.querity.findAll(this.getEntityClass(), query);
        Assertions.assertThat((List)result).hasSize(1);
        Assertions.assertThat((List)result).isEqualTo(this.entities.stream().filter(p -> "Tatooine".equals(p.getAddress().getCity())).collect(Collectors.toList()));
    }

    @Test
    void givenPagination_whenFilterAll_thenReturnThePageElements() {
        Query query = Querity.query().pagination(Integer.valueOf(2), Integer.valueOf(3)).build();
        List result = this.querity.findAll(this.getEntityClass(), query);
        Assertions.assertThat((List)result).hasSize(3);
        Assertions.assertThat((List)result).isEqualTo(this.entities.stream().skip(3L).limit(3L).collect(Collectors.toList()));
    }

    @Test
    void givenSortByFieldAscending_whenFilterAll_thenReturnSortedElements() {
        Query query = Querity.query().sort(new Sort[]{Querity.sortBy((String)"lastName")}).build();
        List result = this.querity.findAll(this.getEntityClass(), query);
        Comparator<Person> comparator = Comparator.comparing(p -> p.getLastName(), this.getSortComparator());
        Assertions.assertThat((List)result).hasSize(6);
        Assertions.assertThat((List)result).isEqualTo(this.entities.stream().sorted(comparator).collect(Collectors.toList()));
    }

    @Test
    void givenSortByFieldDescending_whenFilterAll_thenReturnSortedElements() {
        Query query = Querity.query().sort(new Sort[]{Querity.sortBy((String)"lastName", (Sort.Direction)Sort.Direction.DESC)}).build();
        List result = this.querity.findAll(this.getEntityClass(), query);
        Comparator<Person> comparator = Comparator.comparing(p -> p.getLastName(), this.getSortComparator()).reversed();
        Assertions.assertThat((List)result).hasSize(6);
        Assertions.assertThat((List)result).isEqualTo(this.entities.stream().sorted(comparator).collect(Collectors.toList()));
    }

    @Test
    void givenSortByNestedField_whenFilterAll_thenReturnSortedElements() {
        Query query = Querity.query().sort(new Sort[]{Querity.sortBy((String)"address.city")}).build();
        List result = this.querity.findAll(this.getEntityClass(), query);
        Comparator<Person> comparator = Comparator.comparing(p -> p.getAddress().getCity(), this.getSortComparator());
        Assertions.assertThat((List)result).hasSize(6);
        Assertions.assertThat((List)result).isEqualTo(this.entities.stream().sorted(comparator).collect(Collectors.toList()));
    }

    @Test
    void givenSortByMultipleFields_whenFilterAll_thenReturnSortedElements() {
        Query query = Querity.query().sort(new Sort[]{Querity.sortBy((String)"lastName"), Querity.sortBy((String)"firstName")}).build();
        List result = this.querity.findAll(this.getEntityClass(), query);
        Comparator<Person> comparator = Comparator.comparing(p -> p.getLastName(), this.getSortComparator()).thenComparing(p -> p.getFirstName());
        Assertions.assertThat((List)result).hasSize(6);
        Assertions.assertThat((List)result).isEqualTo(this.entities.stream().sorted(comparator).collect(Collectors.toList()));
    }

    protected <C extends Comparable<? super C>> Comparator<C> getSortComparator() {
        return Comparator.nullsLast(Comparator.naturalOrder());
    }

    @Test
    void givenFilterWithNotConditionWithStringEqualsCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
        Query query = Querity.query().filter((Condition)Querity.not((Condition)Querity.filterBy((String)"lastName", (Operator)Operator.EQUALS, (Object)"Skywalker"))).build();
        List result = this.querity.findAll(this.getEntityClass(), query);
        Assertions.assertThat((List)result).hasSize(4);
        Assertions.assertThat((List)result).isEqualTo(this.entities.stream().filter(p -> !"Skywalker".equals(p.getLastName())).collect(Collectors.toList()));
    }

    @Test
    void givenFilterWithTwoNestedNotConditionsWithStringEqualsCondition_whenFilterAll_thenReturnOnlyFilteredElements() {
        Query query = Querity.query().filter((Condition)Querity.not((Condition)Querity.not((Condition)Querity.filterBy((String)"lastName", (Operator)Operator.EQUALS, (Object)"Skywalker")))).build();
        List result = this.querity.findAll(this.getEntityClass(), query);
        Assertions.assertThat((List)result).hasSize(2);
        Assertions.assertThat((List)result).isEqualTo(this.entities.stream().filter(p -> "Skywalker".equals(p.getLastName())).collect(Collectors.toList()));
    }

    @Test
    void givenFilterWithNotConditionWithTwoStringEqualsConditionsWithAndLogic_whenFilterAll_thenReturnOnlyFilteredElements() {
        Query query = Querity.query().filter((Condition)Querity.not((Condition)Querity.and((Condition[])new Condition[]{Querity.filterBy((String)"lastName", (Operator)Operator.EQUALS, (Object)"Skywalker"), Querity.filterBy((String)"firstName", (Operator)Operator.EQUALS, (Object)"Luke")}))).build();
        List result = this.querity.findAll(this.getEntityClass(), query);
        Assertions.assertThat((List)result).hasSize(5);
        Assertions.assertThat((List)result).isEqualTo(this.entities.stream().filter(p -> !"Skywalker".equals(p.getLastName()) || !"Luke".equals(p.getFirstName())).collect(Collectors.toList()));
    }

    @Test
    void givenFilterWithNotConditionWithTwoStringEqualsConditionsWithOrLogic_whenFilterAll_thenReturnOnlyFilteredElements() {
        Query query = Querity.query().filter((Condition)Querity.not((Condition)Querity.or((Condition[])new Condition[]{Querity.filterBy((String)"lastName", (Operator)Operator.EQUALS, (Object)"Skywalker"), Querity.filterBy((String)"lastName", (Operator)Operator.EQUALS, (Object)"Kenobi")}))).build();
        List result = this.querity.findAll(this.getEntityClass(), query);
        Assertions.assertThat((List)result).hasSize(3);
        Assertions.assertThat((List)result).isEqualTo(this.entities.stream().filter(p -> !"Skywalker".equals(p.getLastName()) && !"Kenobi".equals(p.getLastName())).collect(Collectors.toList()));
    }

    @Test
    void givenFilterWithNotConditionWithNestedConditions_whenFindAll_thenReturnListOfEntity() {
        Query query = Querity.query().filter((Condition)Querity.not((Condition)Querity.and((Condition[])new Condition[]{Querity.filterBy((String)"lastName", (Operator)Operator.EQUALS, (Object)"Skywalker"), Querity.or((Condition[])new Condition[]{Querity.filterBy((String)"firstName", (Operator)Operator.EQUALS, (Object)"Anakin"), Querity.filterBy((String)"firstName", (Operator)Operator.EQUALS, (Object)"Luke")})}))).build();
        List result = this.querity.findAll(this.getEntityClass(), query);
        Assertions.assertThat((List)result).hasSize(4);
        Assertions.assertThat((List)result).isEqualTo(this.entities.stream().filter(p -> !"Skywalker".equals(p.getLastName()) || !"Anakin".equals(p.getFirstName()) && !"Luke".equals(p.getFirstName())).collect(Collectors.toList()));
    }

    @Test
    void givenNullQuery_whenCount_thenReturnAllTheElementsCount() {
        Long count = this.querity.count(this.getEntityClass(), null);
        Assertions.assertThat((Long)count).isEqualTo(6L);
    }

    @Test
    void givenEmptyFilter_whenCount_thenReturnAllTheElementsCount() {
        Long count = this.querity.count(this.getEntityClass(), (Condition)Querity.and((Condition[])new Condition[0]));
        Assertions.assertThat((Long)count).isEqualTo(6L);
    }

    @Test
    void givenFilterWithStringEqualsCondition_whenCount_thenReturnOnlyFilteredElementsCount() {
        Long count = this.querity.count(this.getEntityClass(), (Condition)Querity.filterBy((String)"lastName", (Operator)Operator.EQUALS, (Object)"Skywalker"));
        Assertions.assertThat((Long)count).isEqualTo(2L);
    }

    private List<T> getEntities() {
        List<T> entities = CsvUtils.readCsv("/querity/test-data.csv", this.getEntityClass());
        this.postImportEntities(entities);
        return entities;
    }

    protected void postImportEntities(List<T> entities) {
    }

    private Class<T> getEntityClass() {
        return GenericTypeResolver.resolveTypeArgument(this.getClass(), QuerityGenericSpringTestSuite.class);
    }
}

