/*
 * Decompiled with CFR 0.152.
 */
package net.brunomendola.querity.common.util.valueextractor;

import java.time.ZonedDateTime;
import net.brunomendola.querity.common.util.valueextractor.PropertyValueExtractor;

public class ZonedDateTimeValueExtractor
implements PropertyValueExtractor<ZonedDateTime> {
    @Override
    public boolean canHandle(Class<?> propertyType) {
        return ZonedDateTimeValueExtractor.isZonedDateTimeType(propertyType);
    }

    @Override
    public ZonedDateTime extractValue(Class<?> propertyType, Object value) {
        if (value == null || ZonedDateTimeValueExtractor.isZonedDateTimeType(value.getClass())) {
            return (ZonedDateTime)value;
        }
        return ZonedDateTimeValueExtractor.getZonedDateTimeValue(value.toString());
    }

    private static boolean isZonedDateTimeType(Class<?> cls) {
        return ZonedDateTime.class.isAssignableFrom(cls);
    }

    private static ZonedDateTime getZonedDateTimeValue(String value) {
        return ZonedDateTime.parse(value);
    }
}

