/*
 * Decompiled with CFR 0.152.
 */
package net.brunomendola.querity.common.util.valueextractor;

import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import net.brunomendola.querity.common.util.valueextractor.BooleanValueExtractor;
import net.brunomendola.querity.common.util.valueextractor.DateValueExtractor;
import net.brunomendola.querity.common.util.valueextractor.EnumValueExtractor;
import net.brunomendola.querity.common.util.valueextractor.LocalDateTimeValueExtractor;
import net.brunomendola.querity.common.util.valueextractor.LocalDateValueExtractor;
import net.brunomendola.querity.common.util.valueextractor.NoOpValueExtractor;
import net.brunomendola.querity.common.util.valueextractor.NumericValueExtractor;
import net.brunomendola.querity.common.util.valueextractor.PropertyValueExtractor;
import net.brunomendola.querity.common.util.valueextractor.StringValueExtractor;
import net.brunomendola.querity.common.util.valueextractor.ZonedDateTimeValueExtractor;

public class PropertyValueExtractorFactory {
    public static final NoOpValueExtractor NO_OP_VALUE_EXTRACTOR = new NoOpValueExtractor();
    private static final List<PropertyValueExtractor<?>> extractors = Arrays.asList(new StringValueExtractor(), new NumericValueExtractor(), new BooleanValueExtractor(), new DateValueExtractor(), new LocalDateValueExtractor(), new LocalDateTimeValueExtractor(), new ZonedDateTimeValueExtractor(), new EnumValueExtractor());

    public static PropertyValueExtractor<?> getPropertyValueExtractor(Class<?> propertyType) {
        return extractors.stream().filter(e -> e.canHandle(propertyType)).findAny().orElse(NO_OP_VALUE_EXTRACTOR);
    }

    @Generated
    private PropertyValueExtractorFactory() {
    }
}

