/*
 * Decompiled with CFR 0.152.
 */
package net.brunomendola.querity.common.util.valueextractor;

import java.math.BigDecimal;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.brunomendola.querity.common.util.valueextractor.PropertyValueExtractor;
import org.apache.commons.lang3.math.NumberUtils;

public class NumericValueExtractor
implements PropertyValueExtractor<Number> {
    private static final Set<Class<?>> PRIMITIVE_NUMBERS = Stream.of(Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Byte.TYPE, Short.TYPE).collect(Collectors.toSet());
    private static final Set<Class<?>> FLOATING_POINT_NUMBERS = Stream.of(Float.TYPE, Double.TYPE, BigDecimal.class).collect(Collectors.toSet());

    @Override
    public boolean canHandle(Class<?> propertyType) {
        return NumericValueExtractor.isNumericType(propertyType);
    }

    @Override
    public Number extractValue(Class<?> propertyType, Object value) {
        if (value == null || NumericValueExtractor.isNumericType(value.getClass())) {
            return (Number)value;
        }
        return NumericValueExtractor.getNumericValue(propertyType, value.toString());
    }

    private static boolean isNumericType(Class<?> cls) {
        if (cls.isPrimitive()) {
            return PRIMITIVE_NUMBERS.contains(cls);
        }
        return Number.class.isAssignableFrom(cls);
    }

    private static Number getNumericValue(Class<?> propertyType, String value) {
        if (!NumberUtils.isParsable((String)value)) {
            throw new IllegalArgumentException(String.format("Not a number: %s", value));
        }
        return NumericValueExtractor.isFloatingPointNumber(propertyType) ? new BigDecimal(value) : Long.valueOf(value);
    }

    private static boolean isFloatingPointNumber(Class<?> cls) {
        return FLOATING_POINT_NUMBERS.contains(cls);
    }
}

