/*
 * Decompiled with CFR 0.152.
 */
package net.brunomendola.querity.common.util.valueextractor;

import java.time.LocalDateTime;
import net.brunomendola.querity.common.util.valueextractor.PropertyValueExtractor;

public class LocalDateTimeValueExtractor
implements PropertyValueExtractor<LocalDateTime> {
    @Override
    public boolean canHandle(Class<?> propertyType) {
        return LocalDateTimeValueExtractor.isLocalDateTimeType(propertyType);
    }

    @Override
    public LocalDateTime extractValue(Class<?> propertyType, Object value) {
        if (value == null || LocalDateTimeValueExtractor.isLocalDateTimeType(value.getClass())) {
            return (LocalDateTime)value;
        }
        return LocalDateTimeValueExtractor.getLocalDateTimeValue(value.toString());
    }

    private static boolean isLocalDateTimeType(Class<?> cls) {
        return LocalDateTime.class.isAssignableFrom(cls);
    }

    private static LocalDateTime getLocalDateTimeValue(String value) {
        return LocalDateTime.parse(value);
    }
}

