/*
 * Decompiled with CFR 0.152.
 */
package net.brightroom.featureflag.interceptor;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Objects;
import net.brightroom.featureflag.annotation.FeatureFlag;
import net.brightroom.featureflag.provider.FeatureFlagProvider;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class FeatureFlagInterceptor
implements HandlerInterceptor {
    private final FeatureFlagProvider featureFlagProvider;

    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        FeatureFlag methodAnnotation = (FeatureFlag)handlerMethod.getMethodAnnotation(FeatureFlag.class);
        if (Objects.nonNull(methodAnnotation) && this.checkFeatureFlag(methodAnnotation)) {
            this.writeResponse(response);
            return false;
        }
        FeatureFlag classAnnotation = handlerMethod.getBeanType().getAnnotation(FeatureFlag.class);
        if (Objects.nonNull(classAnnotation) && this.checkFeatureFlag(classAnnotation)) {
            this.writeResponse(response);
            return false;
        }
        return true;
    }

    private boolean checkFeatureFlag(FeatureFlag annotation) {
        if (!annotation.required()) {
            return false;
        }
        return !this.featureFlagProvider.isFeatureEnabled(annotation.feature());
    }

    private void writeResponse(HttpServletResponse response) {
        try {
            response.setStatus(HttpStatus.METHOD_NOT_ALLOWED.value());
            PrintWriter writer = response.getWriter();
            writer.write("This feature is not available");
        }
        catch (IOException e) {
            throw new RuntimeException("Fail to write response.", e);
        }
    }

    public FeatureFlagInterceptor(FeatureFlagProvider featureFlagProvider) {
        this.featureFlagProvider = featureFlagProvider;
    }
}

