/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.bpelunit.util.FileUtil;
import net.bpelunit.util.ZipUtil;
import org.junit.Assert;
import org.junit.Test;

public class ZipUtilTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testZipDirectory() throws Exception {
        File zipFile = this.createZipForTesting();
        ArrayList<String> expectedEntries = new ArrayList<String>();
        expectedEntries.add("a.txt");
        expectedEntries.add("b.txt");
        expectedEntries.add("subdir/a.txt");
        ZipFile f = new ZipFile(zipFile);
        try {
            Enumeration<? extends ZipEntry> entries = f.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                Assert.assertTrue((boolean)expectedEntries.contains(entry.getName()));
                expectedEntries.remove(entry.getName());
            }
            Assert.assertEquals((long)0L, (long)expectedEntries.size());
        }
        finally {
            f.close();
        }
    }

    @Test
    public void testUnzip() throws Exception {
        File zipArchive = this.createZipForTesting();
        File tempDir = FileUtil.createTempDirectory();
        ZipUtil.unzipFile((File)zipArchive, (File)tempDir);
        Assert.assertTrue((boolean)new File(tempDir, "a.txt").isFile());
        Assert.assertTrue((boolean)new File(tempDir, "b.txt").isFile());
        Assert.assertTrue((boolean)new File(tempDir, "subdir").isDirectory());
        Assert.assertTrue((boolean)new File(tempDir, "subdir/a.txt").isFile());
    }

    private File createZipForTesting() throws IOException {
        File tempDir = FileUtil.createTempDirectory();
        new File(tempDir, "a.txt").createNewFile();
        new File(tempDir, "b.txt").createNewFile();
        File subDir = new File(tempDir, "subdir");
        subDir.mkdir();
        new File(subDir, "a.txt").createNewFile();
        File zipFile = File.createTempFile("bpelunit", ".zip");
        ZipUtil.zipDirectory((File)tempDir, (File)zipFile);
        return zipFile;
    }
}

