/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.xml.namespace.QName;
import net.bpelunit.util.FileUtil;
import net.bpelunit.util.XMLUtil;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtilTest {
    @Test
    public void testWriteXMLToStream() throws Exception {
        Document doc = XMLUtil.parseXML((InputStream)this.getClass().getResourceAsStream("simple.xml"));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLUtil.writeXML((Node)doc, (OutputStream)out);
        ByteArrayOutputStream reference = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)this.getClass().getResourceAsStream("simple.xml"), (OutputStream)reference);
        String referenceString = this.normalize(reference.toString());
        String actualString = this.normalize(out.toString());
        Assert.assertEquals((Object)referenceString, (Object)actualString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteXMLToFile() throws Exception {
        Document doc = XMLUtil.parseXML((InputStream)this.getClass().getResourceAsStream("simple.xml"));
        File f = File.createTempFile("bpelunit", ".xml");
        try {
            XMLUtil.writeXML((Node)doc, (File)f);
            ByteArrayOutputStream reference = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)this.getClass().getResourceAsStream("simple.xml"), (OutputStream)reference);
            byte[] actual = FileUtil.readFile((File)f);
            String referenceString = this.normalize(reference.toString("UTF-8"));
            String actualString = this.normalize(new String(actual));
            Assert.assertEquals((Object)referenceString, (Object)actualString);
        }
        finally {
            f.delete();
        }
    }

    @Test
    public void testRemoveNodes() throws Exception {
        Document doc = XMLUtil.parseXML((InputStream)this.getClass().getResourceAsStream("simple.xml"));
        Element root = doc.getDocumentElement();
        List children = XMLUtil.getChildElements((Element)root);
        Element a = (Element)children.get(0);
        Element b = (Element)children.get(1);
        Element c = (Element)children.get(2);
        Assert.assertEquals((long)1L, (long)root.getElementsByTagName("a").getLength());
        Assert.assertEquals((long)1L, (long)root.getElementsByTagName("b").getLength());
        Assert.assertEquals((long)1L, (long)root.getElementsByTagName("c").getLength());
        XMLUtil.removeNodes((Element)root, (NodeList)new NodeListMock(a, b));
        Assert.assertEquals((long)0L, (long)root.getElementsByTagName("a").getLength());
        Assert.assertEquals((long)0L, (long)root.getElementsByTagName("b").getLength());
        Assert.assertEquals((long)1L, (long)root.getElementsByTagName("c").getLength());
        XMLUtil.removeNodes((Element)root, (NodeList)new NodeListMock(a, c));
        Assert.assertEquals((long)0L, (long)XMLUtil.getChildElements((Element)root).size());
    }

    @Test
    public void testGetChildElements() throws Exception {
        Document doc = XMLUtil.parseXML((InputStream)this.getClass().getResourceAsStream("simple.xml"));
        Element root = doc.getDocumentElement();
        List children = XMLUtil.getChildElements((Element)root);
        Assert.assertEquals((long)3L, (long)children.size());
        Assert.assertEquals((Object)"a", (Object)((Element)children.get(0)).getLocalName());
        Assert.assertEquals((Object)"b", (Object)((Element)children.get(1)).getLocalName());
        Assert.assertEquals((Object)"c", (Object)((Element)children.get(2)).getLocalName());
        Assert.assertEquals((long)0L, (long)XMLUtil.getChildElements((Element)((Element)children.get(0))).size());
    }

    @Test
    public void testGetChildElementsByName() throws Exception {
        Document doc = XMLUtil.parseXML((InputStream)this.getClass().getResourceAsStream("simple.xml"));
        Element root = doc.getDocumentElement();
        Assert.assertEquals((long)1L, (long)XMLUtil.getChildElementsByName((Element)root, (String)"a").size());
        Assert.assertEquals((long)0L, (long)XMLUtil.getChildElementsByName((Element)root, (String)"d").size());
    }

    @Test
    public void addAsFirstChildInNonEmptyElement() throws Exception {
        Document doc = XMLUtil.parseXML((InputStream)this.getClass().getResourceAsStream("simple.xml"));
        Element root = doc.getDocumentElement();
        Element element = doc.createElement("d");
        XMLUtil.addAsFirstChild((Element)root, (Element)element);
        Assert.assertEquals((long)4L, (long)XMLUtil.getChildElements((Element)root).size());
        Assert.assertEquals((long)1L, (long)XMLUtil.getChildElementsByName((Element)root, (String)"d").size());
        Assert.assertSame((Object)element, XMLUtil.getChildElements((Element)root).get(0));
    }

    @Test
    public void addAsFirstChildInEmptyElement() throws Exception {
        Document doc = XMLUtil.parseXML((InputStream)this.getClass().getResourceAsStream("simple.xml"));
        Element root = doc.getDocumentElement();
        XMLUtil.removeNodes((Element)root, (NodeList)root.getChildNodes());
        Assert.assertEquals((long)0L, (long)XMLUtil.getChildElements((Element)root).size());
        Element element = doc.createElement("d");
        XMLUtil.addAsFirstChild((Element)root, (Element)element);
        Assert.assertEquals((long)1L, (long)XMLUtil.getChildElements((Element)root).size());
        Assert.assertEquals((long)1L, (long)XMLUtil.getChildElementsByName((Element)root, (String)"d").size());
        Assert.assertSame((Object)element, XMLUtil.getChildElements((Element)root).get(0));
    }

    @Test
    public void testGetQName() throws Exception {
        Document doc = XMLUtil.parseXML((InputStream)this.getClass().getResourceAsStream("simple.xml"));
        Element root = doc.getDocumentElement();
        Assert.assertEquals((Object)new QName("", "simple"), (Object)XMLUtil.getQName((Node)root));
        Assert.assertEquals((Object)new QName("", "b"), (Object)XMLUtil.getQName((Node)doc.createElement("b")));
        Assert.assertEquals((Object)new QName("a", "b"), (Object)XMLUtil.getQName((Node)doc.createElementNS("a", "b")));
    }

    private String normalize(String s) {
        return s.trim().replaceAll("\r", "");
    }

    private static class NodeListMock
    implements NodeList {
        Node[] nodes;

        public NodeListMock(Node ... n) {
            this.nodes = n;
        }

        public int getLength() {
            return this.nodes.length;
        }

        public Node item(int index) {
            return this.nodes[index];
        }
    }
}

