/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.util;

import java.io.File;
import net.bpelunit.util.FileUtil;
import org.junit.Assert;
import org.junit.Test;

public class FileUtilTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTempDirectory() throws Exception {
        File f = null;
        try {
            f = FileUtil.createTempDirectory();
            Assert.assertTrue((boolean)f.exists());
            Assert.assertTrue((boolean)f.isDirectory());
            Assert.assertEquals((long)0L, (long)f.list().length);
        }
        finally {
            if (f != null) {
                f.delete();
            }
        }
    }

    @Test
    public void testReadFile() throws Exception {
        String fileName = "src/test/resources/" + this.getClass().getName().replaceAll("\\.", "/") + ".txt";
        File f = new File(fileName);
        Assert.assertTrue((String)("Test set-up correct: " + f.getAbsolutePath()), (boolean)f.exists());
        byte[] contents = FileUtil.readFile((File)f);
        Assert.assertEquals((long)3L, (long)contents.length);
        Assert.assertArrayEquals((byte[])new byte[]{97, 98, 99}, (byte[])contents);
    }

    @Test
    public void testGetFileNameWithoutSuffix() throws Exception {
        Assert.assertEquals((Object)"test", (Object)FileUtil.getFileNameWithoutSuffix((String)"test.txt"));
        Assert.assertEquals((Object)"test", (Object)FileUtil.getFileNameWithoutSuffix((String)"test.bpel"));
        Assert.assertEquals((Object)"test.txt", (Object)FileUtil.getFileNameWithoutSuffix((String)"test.txt.bpel"));
        Assert.assertEquals((Object)"test", (Object)FileUtil.getFileNameWithoutSuffix((String)"test.txt"));
    }
}

