/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.client.eclipse.preferences;

import java.util.Collection;
import java.util.Map;
import net.bpelunit.framework.client.eclipse.ExtensionControl;
import net.bpelunit.framework.client.model.DataSourceExtension;
import net.bpelunit.framework.client.model.DeployerExtension;
import net.bpelunit.framework.client.model.HeaderProcessorExtension;
import net.bpelunit.framework.client.model.SOAPEncoderExtension;
import net.bpelunit.framework.control.ext.IBPELDeployer;
import net.bpelunit.framework.control.ext.IDataSource;
import net.bpelunit.framework.control.util.ExtensionRegistry;
import net.bpelunit.framework.exception.SpecificationException;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class RegisteredExtensionsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TabFolder tabs;
    private Tree deployersTree;
    private Tree deployersOptionTree;
    private Collection<DeployerExtension> deployers;
    private Tree dataSourcesOptionTree;
    private Tree dataSourcesTree;

    public void init(IWorkbench arg0) {
        this.deployers = ExtensionControl.getDeployers().values();
    }

    protected Control createContents(Composite parent) {
        this.tabs = new TabFolder(parent, 0);
        this.createDeployerTab();
        this.createHeaderProcessorTab();
        this.createSOAPEncodersTab();
        this.createDataSourcesTab();
        return this.tabs;
    }

    private void createDataSourcesTab() {
        TabItem tabDataSources = new TabItem(this.tabs, 0);
        tabDataSources.setText("Data Sources");
        Composite dataSourceComposite = new Composite((Composite)this.tabs, 0);
        dataSourceComposite.setLayout((Layout)new FillLayout(512));
        tabDataSources.setControl((Control)dataSourceComposite);
        this.createDataSourcesTree(dataSourceComposite);
        this.createDataSourcesOptionsTree(dataSourceComposite);
    }

    private void createDataSourcesOptionsTree(Composite dataSourceComposite) {
        this.dataSourcesOptionTree = this.createTree(dataSourceComposite);
        this.addTreeColumn(this.dataSourcesOptionTree, "Name", 100);
        this.addTreeColumn(this.dataSourcesOptionTree, "Default Value", 150);
        this.addTreeColumn(this.dataSourcesOptionTree, "Description", 300);
    }

    private void createDataSourcesTree(Composite dataSourceComposite) {
        this.dataSourcesTree = this.createTree(dataSourceComposite);
        this.addTreeColumn(this.dataSourcesTree, "ID", 100);
        this.addTreeColumn(this.dataSourcesTree, "Name", 200);
        Map<String, DataSourceExtension> dataSources = ExtensionControl.getDataSources();
        for (String name : dataSources.keySet()) {
            TreeItem ti = new TreeItem(this.dataSourcesTree, 0);
            DataSourceExtension dataSource = dataSources.get(name);
            ti.setText(new String[]{dataSource.getId(), dataSource.getName()});
            ti.setData((Object)dataSource);
        }
        this.dataSourcesTree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RegisteredExtensionsPreferencePage.this.dataSourcesOptionTree.removeAll();
                if (RegisteredExtensionsPreferencePage.this.dataSourcesTree.getSelectionCount() == 1) {
                    DataSourceExtension ds = (DataSourceExtension)RegisteredExtensionsPreferencePage.this.dataSourcesTree.getSelection()[0].getData();
                    try {
                        Class<?> dsClass = ds.createNew().getClass();
                        Map annotations = ExtensionRegistry.getConfigurationAnnotations(dsClass);
                        for (String name : annotations.keySet()) {
                            TreeItem ti = new TreeItem(RegisteredExtensionsPreferencePage.this.dataSourcesOptionTree, 0);
                            IDataSource.ConfigurationOption annotation = (IDataSource.ConfigurationOption)annotations.get(name);
                            ti.setText(new String[]{name, annotation.defaultValue(), annotation.description()});
                        }
                    }
                    catch (SpecificationException e1) {
                        RegisteredExtensionsPreferencePage.this.logException(e1);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
    }

    private void logException(SpecificationException e) {
        e.printStackTrace();
    }

    private void createSOAPEncodersTab() {
        TabItem tabSOAPEncoders = new TabItem(this.tabs, 0);
        tabSOAPEncoders.setText("SOAP Encoders");
        Tree soapEncodersTree = this.createTree((Composite)this.tabs);
        this.addTreeColumn(soapEncodersTree, "ID", 100);
        this.addTreeColumn(soapEncodersTree, "Name", 200);
        Map<String, SOAPEncoderExtension> soapEncoders = ExtensionControl.getSOAPEncoders();
        for (String name : soapEncoders.keySet()) {
            TreeItem ti = new TreeItem(soapEncodersTree, 0);
            ti.setText(new String[]{soapEncoders.get(name).getId(), soapEncoders.get(name).getName()});
        }
        tabSOAPEncoders.setControl((Control)soapEncodersTree);
    }

    private void createHeaderProcessorTab() {
        TabItem tabHeaderProcessors = new TabItem(this.tabs, 0);
        tabHeaderProcessors.setText("Header Processors");
        Tree headerProcessorTree = this.createTree((Composite)this.tabs);
        this.addTreeColumn(headerProcessorTree, "ID", 100);
        this.addTreeColumn(headerProcessorTree, "Name", 200);
        Map<String, HeaderProcessorExtension> headerProcessors = ExtensionControl.getHeaderProcessors();
        for (String name : headerProcessors.keySet()) {
            TreeItem ti = new TreeItem(headerProcessorTree, 0);
            ti.setText(new String[]{headerProcessors.get(name).getId(), headerProcessors.get(name).getName()});
        }
        tabHeaderProcessors.setControl((Control)headerProcessorTree);
    }

    private Tree createTree(Composite parent) {
        Tree tree = new Tree(parent, 2816);
        tree.setHeaderVisible(true);
        return tree;
    }

    private TreeColumn addTreeColumn(Tree tree, String name, int width) {
        TreeColumn c = new TreeColumn(tree, 16384);
        c.setText(name);
        c.setWidth(width);
        return c;
    }

    private void createDeployerTab() {
        TabItem tabDeployers = new TabItem(this.tabs, 0);
        tabDeployers.setText("Deployers");
        Composite deployersComposite = new Composite((Composite)this.tabs, 0);
        tabDeployers.setControl((Control)deployersComposite);
        deployersComposite.setLayout((Layout)new FillLayout(512));
        this.createDeployerTree(deployersComposite);
        this.createDeployerOptionTree(deployersComposite);
    }

    private void createDeployerTree(Composite deployersComposite) {
        this.deployersTree = this.createTree(deployersComposite);
        this.addTreeColumn(this.deployersTree, "ID", 100);
        this.addTreeColumn(this.deployersTree, "Deployer Name", 150);
        this.addTreeColumn(this.deployersTree, "Deploy", 150);
        this.addTreeColumn(this.deployersTree, "Measure Test Coverage", 150);
        this.addTreeColumn(this.deployersTree, "Endpoint Replacement", 150);
        for (DeployerExtension d : this.deployers) {
            try {
                IBPELDeployer deployer = d.createNew();
                IBPELDeployer.IBPELDeployerCapabilities annotation = deployer.getClass().getAnnotation(IBPELDeployer.IBPELDeployerCapabilities.class);
                if (annotation == null) continue;
                TreeItem treeItem = new TreeItem(this.deployersTree, 0);
                treeItem.setText(new String[]{d.getId(), d.getName(), new Boolean(annotation.canDeploy()).toString(), new Boolean(annotation.canMeasureTestCoverage()).toString(), new Boolean(annotation.canIntroduceMocks()).toString()});
                treeItem.setData((Object)d);
            }
            catch (SpecificationException e) {
                this.logException(e);
            }
        }
        this.deployersTree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RegisteredExtensionsPreferencePage.this.deployersOptionTree.removeAll();
                if (RegisteredExtensionsPreferencePage.this.deployersTree.getSelectionCount() == 1) {
                    TreeItem selection = RegisteredExtensionsPreferencePage.this.deployersTree.getSelection()[0];
                    try {
                        Class<?> deployerClass = ((DeployerExtension)selection.getData()).createNew().getClass();
                        Map options = ExtensionRegistry.getConfigurationAnnotations(deployerClass, (boolean)true);
                        for (String option : options.keySet()) {
                            IBPELDeployer.IBPELDeployerOption annotation = (IBPELDeployer.IBPELDeployerOption)options.get(option);
                            TreeItem item = new TreeItem(RegisteredExtensionsPreferencePage.this.deployersOptionTree, 0);
                            item.setText(new String[]{option, annotation.defaultValue(), new Boolean(annotation.testSuiteSpecific()).toString()});
                        }
                    }
                    catch (SpecificationException e1) {
                        RegisteredExtensionsPreferencePage.this.logException(e1);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
    }

    private void createDeployerOptionTree(Composite deployersComposite) {
        this.deployersOptionTree = this.createTree(deployersComposite);
        this.addTreeColumn(this.deployersOptionTree, "Deployer Option", 200);
        this.addTreeColumn(this.deployersOptionTree, "Default Value", 200);
        this.addTreeColumn(this.deployersOptionTree, "Test Suite Only", 100);
    }
}

