/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.client.eclipse.preferences;

import net.bpelunit.framework.client.eclipse.BPELUnitActivator;
import net.bpelunit.framework.client.eclipse.ExtensionControl;
import net.bpelunit.framework.client.eclipse.preferences.ComboFieldEditor;
import net.bpelunit.framework.client.eclipse.preferences.OptionTableFieldEditor;
import net.bpelunit.framework.client.model.DeployerExtension;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class BPELUnitDeploymentPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private ComboFieldEditor fComboFieldEditor;
    private OptionTableFieldEditor fOptionTableFieldEditor;
    private BooleanFieldEditor fEndpointModificationFlag;

    public BPELUnitDeploymentPreferencePage() {
        super(1);
        this.setPreferenceStore(BPELUnitActivator.getDefault().getPreferenceStore());
        this.setDescription("Deployment Preferences");
    }

    public void createFieldEditors() {
        this.createSpacer(this.getFieldEditorParent(), 2);
        String[][] deployerIds = ExtensionControl.getDeployerMetaInformation();
        this.fComboFieldEditor = new ComboFieldEditor("CurrentDeployer", "&Deployer:", deployerIds, this.getFieldEditorParent());
        this.fComboFieldEditor.setPropertyChangeListener((IPropertyChangeListener)this);
        this.addField(this.fComboFieldEditor);
        this.fOptionTableFieldEditor = new OptionTableFieldEditor("Options", "&Options for selected deployer:", this.getFieldEditorParent());
        this.addField(this.fOptionTableFieldEditor);
        this.createSpacer(this.getFieldEditorParent(), 2);
        this.fEndpointModificationFlag = new BooleanFieldEditor("EndpointModification", "Automatically modify endpoints to simulated URLs", this.getFieldEditorParent());
        this.fEndpointModificationFlag.setPropertyChangeListener((IPropertyChangeListener)this);
        this.addField((FieldEditor)this.fEndpointModificationFlag);
        String current = this.getPreferenceStore().getString("CurrentDeployer");
        if (current.equals("")) {
            current = this.getPreferenceStore().getDefaultString("CurrentDeployer");
        }
        DeployerExtension deployerExtension = ExtensionControl.findDeployerExtension(current);
        this.fOptionTableFieldEditor.setDeployer(deployerExtension);
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        FieldEditor editor = (FieldEditor)event.getSource();
        if (editor == this.fComboFieldEditor) {
            DeployerExtension deployerExtension = ExtensionControl.findDeployerExtension(this.fComboFieldEditor.getCurrentSelectionString());
            this.fOptionTableFieldEditor.setDeployer(deployerExtension);
        }
    }

    public void init(IWorkbench workbench) {
    }

    protected void createSpacer(Composite composite, int columnSpan) {
        Label label = new Label(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = columnSpan;
        label.setLayoutData((Object)gd);
    }
}

