/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.client.eclipse.launch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.bpelunit.framework.client.eclipse.BPELUnitActivator;
import net.bpelunit.framework.client.eclipse.launch.LaunchConstants;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class BPELLaunchShortCut
implements ILaunchShortcut {
    public void launch(ISelection selection, String mode) {
        IStructuredSelection sel;
        Object o;
        if (selection instanceof IStructuredSelection && (o = (sel = (IStructuredSelection)selection).getFirstElement()) instanceof IFile) {
            this.launch((IFile)o, mode);
        }
    }

    public void launch(IEditorPart editor, String mode) {
        IEditorInput input = editor.getEditorInput();
        IFile file = (IFile)input.getAdapter(IFile.class);
        if (file != null) {
            this.launch(file, mode);
        }
    }

    private void launch(IFile file, String mode) {
        ILaunchConfiguration config = this.findLaunchConfiguration(file, this.getConfigurationType());
        if (config != null) {
            DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
        }
    }

    protected ILaunchConfiguration findLaunchConfiguration(IFile file, ILaunchConfigurationType configType) {
        ILaunchConfiguration config;
        List candidateConfigs = Collections.emptyList();
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            candidateConfigs = new ArrayList(configs.length);
            ILaunchConfiguration[] iLaunchConfigurationArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                config = iLaunchConfigurationArray[n2];
                if (config.getAttribute(LaunchConstants.ATTR_PROJECT_NAME, "").equals(file.getProject().getName()) && config.getAttribute(LaunchConstants.ATTR_SUITE_FILE_NAME, "").equals(file.getProjectRelativePath().toString())) {
                    candidateConfigs.add(config);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            BPELUnitActivator.log(e);
        }
        int candidateCount = candidateConfigs.size();
        if (candidateCount < 1) {
            return this.createConfiguration(file);
        }
        if (candidateCount == 1) {
            return (ILaunchConfiguration)candidateConfigs.get(0);
        }
        config = this.chooseConfiguration(candidateConfigs);
        if (config != null) {
            return config;
        }
        return null;
    }

    protected ILaunchConfiguration chooseConfiguration(List<?> configList) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle("Select Test Suite");
        dialog.setMessage("&Select existing configuration:");
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    private Shell getShell() {
        return BPELUnitActivator.getActiveWorkbenchWindow().getShell();
    }

    protected ILaunchConfigurationType getConfigurationType() {
        return this.getLaunchManager().getLaunchConfigurationType("net.bpelunit.framework.client.eclipse.testSuiteLauncher");
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected ILaunchConfiguration createConfiguration(IFile file) {
        ILaunchConfiguration config = null;
        ILaunchConfigurationWorkingCopy wc = null;
        String configName = file.getName();
        int index = configName.lastIndexOf(46);
        if (index != -1) {
            configName = configName.substring(0, index);
        }
        try {
            ILaunchConfigurationType configType = this.getConfigurationType();
            wc = configType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(configName));
            wc.setAttribute(LaunchConstants.ATTR_PROJECT_NAME, file.getProject().getName());
            wc.setAttribute(LaunchConstants.ATTR_SUITE_FILE_NAME, file.getProjectRelativePath().toString());
            wc.setMappedResources(new IResource[]{file.getProject()});
            config = wc.doSave();
        }
        catch (CoreException exception) {
            this.reportError(exception);
        }
        return config;
    }

    protected void reportError(CoreException exception) {
        MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)exception.getStatus().getMessage());
    }
}

