/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.client.eclipse.dialog.field;

import java.util.ArrayList;
import java.util.List;
import net.bpelunit.framework.client.eclipse.BPELUnitActivator;
import net.bpelunit.framework.client.eclipse.dialog.Field;
import net.bpelunit.framework.client.eclipse.dialog.FieldBasedInputDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class SelectionField
extends Field {
    private Text fText;
    private String fButtonTitle;
    private String fCurrentSelection;
    private String[] fChoices;
    private List<ModifyListener> fModifyListeners = new ArrayList<ModifyListener>();

    public SelectionField(FieldBasedInputDialog inputDialog, String labelText, String initialValue, String buttonTitle, String[] choices) {
        super(inputDialog, labelText, initialValue);
        this.fChoices = choices;
        this.fButtonTitle = buttonTitle;
    }

    @Override
    public void createControl(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(this.getLabelText());
        label.setLayoutData((Object)new GridData(32));
        Composite comp = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        this.fText = new Text(comp, 2052);
        GridData data = new GridData(768);
        data.widthHint = 200;
        this.fText.setLayoutData((Object)data);
        label.setSize(label.getSize().x, this.fText.getSize().y);
        if (this.getInitialValue() != null) {
            this.fText.setText(this.getInitialValue());
        }
        this.fCurrentSelection = this.fText.getText();
        this.fText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectionField.this.fCurrentSelection = SelectionField.this.fText.getText();
                SelectionField.this.getDialog().validateFields();
                for (ModifyListener ml : SelectionField.this.fModifyListeners) {
                    ml.modifyText(e);
                }
            }
        });
        Button button = this.createButton(comp, 9, this.fButtonTitle, false);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] res;
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(SelectionField.this.getShell(), (ILabelProvider)new SimpleLabelProvider());
                dialog.setElements((Object[])SelectionField.this.fChoices);
                dialog.setTitle("Options");
                dialog.setMessage("Select one of the options.");
                dialog.setMultipleSelection(false);
                int code = dialog.open();
                if (code == 0 && (res = dialog.getResult()) != null && res.length > 0) {
                    String variable = (String)res[0];
                    SelectionField.this.fCurrentSelection = variable;
                    SelectionField.this.fText.setText(variable);
                    SelectionField.this.getDialog().validateFields();
                }
            }
        });
    }

    protected Shell getShell() {
        return this.getDialog().getShell();
    }

    @Override
    public String getSelection() {
        return this.fCurrentSelection;
    }

    public void addModifyListener(ModifyListener ml) {
        this.fModifyListeners.add(ml);
    }

    class SimpleLabelProvider
    implements ILabelProvider {
        private Image fBpelImage;

        SimpleLabelProvider() {
        }

        public Image getImage(Object element) {
            if (this.fBpelImage == null) {
                this.fBpelImage = BPELUnitActivator.getImageDescriptor("icons/bpel.gif").createImage();
            }
            return this.fBpelImage;
        }

        public String getText(Object element) {
            return (String)element;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
            if (this.fBpelImage != null && !this.fBpelImage.isDisposed()) {
                this.fBpelImage.dispose();
            }
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

