/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.model.test.activity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import net.bpelunit.framework.control.ext.IHeaderProcessor;
import net.bpelunit.framework.control.ext.SendPackage;
import net.bpelunit.framework.control.run.TestCaseRunner;
import net.bpelunit.framework.exception.HeaderProcessingException;
import net.bpelunit.framework.exception.SynchronousSendException;
import net.bpelunit.framework.model.test.PartnerTrack;
import net.bpelunit.framework.model.test.activity.VelocityContextProvider;
import net.bpelunit.framework.model.test.data.DataCopyOperation;
import net.bpelunit.framework.model.test.data.ReceiveDataSpecification;
import net.bpelunit.framework.model.test.data.SendDataSpecification;
import net.bpelunit.framework.model.test.wire.IncomingMessage;
import net.bpelunit.framework.model.test.wire.OutgoingMessage;
import org.apache.velocity.context.Context;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityContext
implements VelocityContextProvider {
    private TestCaseRunner fRunner;
    private PartnerTrack fTrack;
    private IHeaderProcessor fHeaderProcessor;
    private List<DataCopyOperation> fMapping;
    private Map<String, String> fUserData = new HashMap<String, String>();
    private String fSimulatedURL;
    private List<Element> fReceivedMessages = new ArrayList<Element>();
    private List<Element> fSentMessages = new ArrayList<Element>();

    public ActivityContext(TestCaseRunner runner, PartnerTrack track) {
        this.fRunner = runner;
        this.fTrack = track;
        this.fSimulatedURL = this.fTrack.getPartner().getSimulatedURL();
    }

    public ActivityContext(String simulatedURL) {
        this.fRunner = null;
        this.fTrack = null;
        this.fSimulatedURL = simulatedURL;
    }

    public IncomingMessage receiveMessage(PartnerTrack track) throws TimeoutException, InterruptedException {
        return this.fRunner.receiveMessage(track);
    }

    public void postAnswer(PartnerTrack track, OutgoingMessage msg) throws TimeoutException, InterruptedException {
        this.fRunner.sendBackMessage(track, msg);
    }

    public IncomingMessage sendMessage(OutgoingMessage msg) throws SynchronousSendException, InterruptedException {
        return this.fRunner.sendMessageSynchronous(msg);
    }

    public void setHeaderProcessor(IHeaderProcessor headerProcessor) {
        this.fHeaderProcessor = headerProcessor;
    }

    public void processHeaders(ReceiveDataSpecification spec) throws HeaderProcessingException {
        if (this.fHeaderProcessor != null) {
            this.fHeaderProcessor.processReceive(this, spec.getSOAPMessage());
        }
    }

    public void processHeaders(SendDataSpecification spec) throws HeaderProcessingException {
        if (this.fHeaderProcessor != null) {
            SendPackage sp = new SendPackage(spec.getTargetURL(), spec.getSOAPMessage());
            this.fHeaderProcessor.processSend(this, sp);
            spec.setTargetURL(sp.getTargetURL());
        }
    }

    public void setMapping(List<DataCopyOperation> mapping) {
        this.fMapping = mapping;
    }

    public List<DataCopyOperation> getMapping() {
        return this.fMapping;
    }

    public void setUserData(String key, String value) {
        this.fUserData.put(key, value);
    }

    public String getUserData(String key) {
        String returner = this.fUserData.get(key);
        return returner == null ? "" : returner;
    }

    public String getPartnerURL() {
        return this.fSimulatedURL;
    }

    public void setSimulatedURL(String simulatedURL) {
        this.fSimulatedURL = simulatedURL;
    }

    public Element getLastRequest() {
        return this.fReceivedMessages.size() > 0 ? this.fReceivedMessages.get(this.fReceivedMessages.size() - 1) : null;
    }

    public List<Element> getReceivedMessages() {
        return this.fReceivedMessages;
    }

    public void saveReceivedMessage(Element msg) {
        this.fReceivedMessages.add(msg);
    }

    public List<Element> getSentMessages() {
        return this.fSentMessages;
    }

    public void saveSentMessage(Element msg) {
        this.fSentMessages.add(msg);
    }

    @Override
    public Context createVelocityContext() throws Exception {
        return this.fTrack.createVelocityContext();
    }
}

