/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.coverage.annotation.metrics.branchcoverage.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.bpelunit.framework.coverage.annotation.metrics.branchcoverage.BranchMetricHandler;
import net.bpelunit.framework.coverage.annotation.metrics.branchcoverage.IStructuredActivityHandler;
import net.bpelunit.framework.coverage.annotation.tools.bpelxmltools.BpelXMLTools;
import net.bpelunit.framework.coverage.exceptions.BpelException;
import net.bpelunit.framework.coverage.receiver.MarkersRegisterForArchive;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.filter.ContentFilter;
import org.jdom.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowHandler
implements IStructuredActivityHandler {
    private MarkersRegisterForArchive markersRegistry;

    public FlowHandler(MarkersRegisterForArchive markersRegistry) {
        this.markersRegistry = markersRegistry;
    }

    @Override
    public void insertBranchMarkers(Element flow) throws BpelException {
        this.loggingOfBranches(flow);
    }

    private void loggingOfBranches(Element element) {
        List children = element.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            Element child = (Element)children.get(i);
            if (!BpelXMLTools.isActivity(child)) continue;
            if (this.isTargetOfLinks(child)) {
                this.markersRegistry.registerMarker(BranchMetricHandler.insertLabelBevorAllActivities(child));
                continue;
            }
            List<Element> createInstanceElement = this.getCreateInstanceActivity(child);
            if (createInstanceElement.size() > 0) {
                for (Element el : createInstanceElement) {
                    BpelXMLTools.ensureElementIsInSequence(el);
                    this.markersRegistry.registerMarker(BranchMetricHandler.insertLabelAfterActivity(el));
                }
                continue;
            }
            this.markersRegistry.registerMarker(BranchMetricHandler.insertLabelBevorAllActivities(child));
        }
    }

    private List<Element> getCreateInstanceActivity(Element activity) {
        ArrayList<Element> list = new ArrayList<Element>();
        String name = activity.getName();
        if ((name.equals("pick") || name.equals("receive")) && BpelXMLTools.canCreateInstance(activity)) {
            list.add(activity);
            return list;
        }
        if (BpelXMLTools.isStructuredActivity(activity)) {
            Iterator iter = activity.getDescendants((Filter)new ContentFilter(1){

                public boolean matches(Object obj) {
                    Element el;
                    return super.matches(obj) && BpelXMLTools.canCreateInstance(el = (Element)obj);
                }
            });
            while (iter.hasNext()) {
                list.add((Element)iter.next());
            }
        }
        return list;
    }

    private boolean isTargetOfLinks(Element element) {
        Element target;
        boolean isTarget = false;
        Namespace ns = BpelXMLTools.getProcessNamespace();
        if (ns.equals((Object)BpelXMLTools.NAMESPACE_BPEL_1_1)) {
            Element target2 = element.getChild("target", ns);
            if (target2 != null) {
                isTarget = true;
            }
        } else if (ns.equals((Object)BpelXMLTools.NAMESPACE_BPEL_2_0) && (target = element.getChild("targets", ns)) != null) {
            isTarget = true;
        }
        return isTarget;
    }
}

