/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.coverage.annotation.metrics.branchcoverage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.bpelunit.framework.coverage.annotation.metrics.IMetricHandler;
import net.bpelunit.framework.coverage.annotation.metrics.branchcoverage.IStructuredActivityHandler;
import net.bpelunit.framework.coverage.annotation.metrics.branchcoverage.impl.FlowHandler;
import net.bpelunit.framework.coverage.annotation.metrics.branchcoverage.impl.ForEachHandler;
import net.bpelunit.framework.coverage.annotation.metrics.branchcoverage.impl.IfHandler;
import net.bpelunit.framework.coverage.annotation.metrics.branchcoverage.impl.PickHandler;
import net.bpelunit.framework.coverage.annotation.metrics.branchcoverage.impl.RepeatUntilHandler;
import net.bpelunit.framework.coverage.annotation.metrics.branchcoverage.impl.SequenceHandler;
import net.bpelunit.framework.coverage.annotation.metrics.branchcoverage.impl.SwitchHandler;
import net.bpelunit.framework.coverage.annotation.metrics.branchcoverage.impl.WhileHandler;
import net.bpelunit.framework.coverage.annotation.tools.bpelxmltools.BpelXMLTools;
import net.bpelunit.framework.coverage.exceptions.BpelException;
import net.bpelunit.framework.coverage.receiver.MarkersRegisterForArchive;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchMetricHandler
implements IMetricHandler {
    public static final String METRIC_NAME = "Branchmetric";
    public static final String BRANCH_LABEL = "branch";
    private HashMap<String, IStructuredActivityHandler> structured_activity_handler = new HashMap();

    private static String getNextMarker() {
        String marker = "branch_" + BpelXMLTools.count++;
        return marker;
    }

    public static String insertLabelBevorAllActivities(Element activity) {
        if (!BpelXMLTools.isSequence(activity = BranchMetricHandler.respectTargetsOfLinks(activity))) {
            activity = BpelXMLTools.ensureElementIsInSequence(activity);
        }
        String marker = BranchMetricHandler.getNextMarker();
        activity.addContent(0, (Content)new Comment("@coverageLabel" + marker));
        return marker;
    }

    private static Element respectTargetsOfLinks(Element activity) {
        List<Element> targets = BranchMetricHandler.getTargets(activity);
        if (targets.size() > 0) {
            Element sequence = BpelXMLTools.createSequence();
            Iterator<Element> iter = targets.iterator();
            while (iter.hasNext()) {
                sequence.addContent(iter.next().detach());
            }
            Element parent = activity.getParentElement();
            int index = parent.indexOf((Content)activity);
            parent.addContent(index, (Content)sequence);
            sequence.addContent(activity.detach());
            activity = sequence;
        }
        return activity;
    }

    public static String insertLabelAfterAllActivities(Element activity) {
        if (!BpelXMLTools.isSequence(activity)) {
            activity = BpelXMLTools.ensureElementIsInSequence(activity);
        }
        String marker = BranchMetricHandler.getNextMarker();
        activity.addContent((Content)new Comment("@coverageLabel" + marker));
        return marker;
    }

    public static String insertLabelAfterActivity(Element activity) {
        Element parent = activity.getParentElement();
        String marker = BranchMetricHandler.getNextMarker();
        parent.addContent(parent.indexOf((Content)activity) + 1, (Content)new Comment("@coverageLabel" + marker));
        return marker;
    }

    public static String insertLabelBevorActivity(Element activity) {
        activity = BranchMetricHandler.respectTargetsOfLinks(activity);
        Element parent = activity.getParentElement();
        String marker = BranchMetricHandler.getNextMarker();
        parent.addContent(parent.indexOf((Content)activity), (Content)new Comment("@coverageLabel" + marker));
        return marker;
    }

    public static List<Element> getTargets(Element child) {
        Element target;
        Namespace ns = BpelXMLTools.getProcessNamespace();
        ArrayList<Element> targets = new ArrayList<Element>();
        if (ns.equals((Object)BpelXMLTools.NAMESPACE_BPEL_1_1)) {
            targets.addAll(child.getChildren("target", ns));
        } else if (ns.equals((Object)BpelXMLTools.NAMESPACE_BPEL_2_0) && (target = child.getChild("targets", ns)) != null) {
            targets.add(target);
        }
        return targets;
    }

    public BranchMetricHandler(MarkersRegisterForArchive markersRegistry) {
        this.structured_activity_handler.put("flow", new FlowHandler(markersRegistry));
        this.structured_activity_handler.put("sequence", new SequenceHandler(markersRegistry));
        this.structured_activity_handler.put("if", new IfHandler(markersRegistry));
        this.structured_activity_handler.put("while", new WhileHandler(markersRegistry));
        this.structured_activity_handler.put("repeatUntil", new RepeatUntilHandler(markersRegistry));
        this.structured_activity_handler.put("forEach", new ForEachHandler(markersRegistry));
        this.structured_activity_handler.put("pick", new PickHandler(markersRegistry));
        this.structured_activity_handler.put("switch", new SwitchHandler(markersRegistry));
    }

    @Override
    public void insertMarkersForMetric(List<Element> activities) throws BpelException {
        for (Element next_element : activities) {
            String next_element_name = next_element.getName();
            if (!this.structured_activity_handler.containsKey(next_element_name)) continue;
            this.structured_activity_handler.get(next_element_name).insertBranchMarkers(next_element);
        }
    }

    public String toString() {
        return METRIC_NAME;
    }

    public String getName() {
        return METRIC_NAME;
    }
}

