/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.coverage.annotation;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import net.bpelunit.framework.coverage.annotation.metrics.IMetric;
import net.bpelunit.framework.coverage.annotation.metrics.activitycoverage.ActivityMetric;
import net.bpelunit.framework.coverage.annotation.metrics.branchcoverage.BranchMetric;
import net.bpelunit.framework.coverage.annotation.metrics.chcoverage.CompensationMetric;
import net.bpelunit.framework.coverage.annotation.metrics.fhcoverage.FaultMetric;
import net.bpelunit.framework.coverage.annotation.metrics.linkcoverage.LinkMetric;
import net.bpelunit.framework.coverage.receiver.MarkerState;
import net.bpelunit.framework.coverage.receiver.MarkersRegisterForArchive;
import net.bpelunit.framework.coverage.result.statistic.IStatistic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetricsManager {
    private List<IMetric> metrics = new ArrayList<IMetric>();

    public static List<MarkerState> getStatus(String label, Hashtable<String, Hashtable<String, MarkerState>> allLabels) {
        ArrayList<MarkerState> list = new ArrayList<MarkerState>();
        if (allLabels.get(label) != null) {
            Hashtable<String, MarkerState> activityTable = allLabels.get(label);
            Enumeration<MarkerState> e = activityTable.elements();
            while (e.hasMoreElements()) {
                list.add(e.nextElement());
            }
        }
        return list;
    }

    public static IMetric createMetric(String name, List<String> list, MarkersRegisterForArchive markersRegistry) {
        IMetric metric = null;
        if (name.equals("ActivityCoverage")) {
            metric = new ActivityMetric(list, markersRegistry);
        } else if (name.equals("BranchCoverage")) {
            metric = new BranchMetric(markersRegistry);
        } else if (name.equals("CompensationHandlerCoverage")) {
            metric = new CompensationMetric(markersRegistry);
        } else if (name.equals("FaultHandlerCoverage")) {
            metric = new FaultMetric(markersRegistry);
        } else if (name.equals("LinkCoverage")) {
            metric = new LinkMetric(markersRegistry);
        }
        return metric;
    }

    public void addMetric(IMetric metric) {
        this.metrics.add(metric);
    }

    public List<IMetric> getMetrics() {
        return this.metrics;
    }

    public boolean hasMetric(String metricname) {
        Iterator<IMetric> iter = this.metrics.iterator();
        while (iter.hasNext()) {
            if (!iter.next().getName().equals(metricname)) continue;
            return true;
        }
        return false;
    }

    public List<IStatistic> createStatistics(Hashtable<String, Hashtable<String, MarkerState>> allMarkers) {
        ArrayList<IStatistic> statistics = new ArrayList<IStatistic>();
        Iterator<IMetric> iter = this.metrics.iterator();
        while (iter.hasNext()) {
            statistics.add(iter.next().createStatistic(allMarkers));
        }
        return statistics;
    }
}

