/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.control.deploy.oracle;

import java.io.File;
import java.io.IOException;
import net.bpelunit.framework.BPELUnitRunner;
import net.bpelunit.framework.control.deploy.oracle.StreamReader;
import net.bpelunit.framework.control.ext.IBPELDeployer;
import net.bpelunit.framework.control.ext.IDeployment;
import net.bpelunit.framework.coverage.ICoverageMeasurementTool;
import net.bpelunit.framework.exception.DeploymentException;
import net.bpelunit.framework.model.ProcessUnderTest;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

@IBPELDeployer.IBPELDeployerCapabilities(canDeploy=true)
public class OracleDeployer
implements IBPELDeployer {
    private static final String KEYWORD_UNDEPLOY = "undeploy";
    private static final String KEYWORD_DEPLOY = "deploy";
    private static final String BPELDEPLOY_SCRIPT_NAME = "bpeldeploy.bat";
    private static final String ORACLE_BIN_DIRECTORY = "bin/";
    private Logger fLogger = Logger.getLogger(this.getClass());
    private String fProcessName;
    private String fBinDir;
    private String fBPELFilePath;
    private String fScriptFilePath;
    private String fDomain;
    private String fPassword;
    private String fOracleDirectory;

    @IBPELDeployer.IBPELDeployerOption(testSuiteSpecific=true)
    public void setBPELJARPath(String value) {
        this.fBPELFilePath = value;
    }

    @IBPELDeployer.IBPELDeployerOption
    public void setOracleDirectory(String value) {
        this.fOracleDirectory = value;
    }

    @IBPELDeployer.IBPELDeployerOption
    public void setOracleDomain(String value) {
        this.fDomain = value;
    }

    @IBPELDeployer.IBPELDeployerOption
    public void setOracleDomainPassword(String value) {
        this.fPassword = value;
    }

    public void deploy(String path, ProcessUnderTest processUnderTest) throws DeploymentException {
        if (BPELUnitRunner.measureTestCoverage()) {
            ICoverageMeasurementTool tool = BPELUnitRunner.getCoverageMeasurmentTool();
            tool.setErrorStatus("Test coverage for Oracle Deployer is not implemented!");
        }
        this.fLogger.info((Object)("Oracle BPEL deployer got deploy request for PUT " + processUnderTest));
        this.check(this.fBPELFilePath, "BPEL JAR file");
        this.check(this.fOracleDirectory, "Oracle Directory");
        if (!new File(this.fOracleDirectory).exists()) {
            throw new DeploymentException("The specified Oracle Directory does not exist.");
        }
        this.fProcessName = processUnderTest.getName();
        this.fBPELFilePath = FilenameUtils.concat((String)path, (String)this.fBPELFilePath);
        this.fScriptFilePath = FilenameUtils.concat((String)this.fOracleDirectory, (String)FilenameUtils.concat((String)ORACLE_BIN_DIRECTORY, (String)BPELDEPLOY_SCRIPT_NAME));
        this.fBinDir = this.fOracleDirectory;
        if (this.fBinDir.endsWith("/") || this.fBinDir.endsWith("\\")) {
            this.fBinDir = this.fBinDir.substring(0, this.fBinDir.length());
        }
        this.fBinDir = FilenameUtils.separatorsToSystem((String)this.fBinDir);
        this.check(this.fBPELFilePath, "BPEL JAR file");
        if (!new File(this.fBPELFilePath).exists()) {
            throw new DeploymentException("The referenced BPEL JAR file for Oracle deployment does not exist: " + this.fBPELFilePath);
        }
        this.check(this.fScriptFilePath, "deployment script file path");
        if (!new File(this.fScriptFilePath).exists()) {
            throw new DeploymentException("The referenced deployment script file for Oracle deployment does not exist: " + this.fScriptFilePath);
        }
        this.check(this.fProcessName, "BPEL Process Name");
        this.check(this.fDomain, "BPEL server domain name");
        this.check(this.fPassword, "BPEL server domain password");
        String[] cmd = this.generateDeploy(this.fScriptFilePath, this.fProcessName, this.fBPELFilePath, this.fDomain, this.fPassword);
        this.runExternal(cmd);
    }

    public void undeploy(String path, ProcessUnderTest processUnderTest) throws DeploymentException {
        if (this.fScriptFilePath != null && this.fProcessName != null && this.fDomain != null && this.fPassword != null) {
            String[] cmd = this.generateUndeploy(this.fScriptFilePath, this.fProcessName, this.fDomain, this.fPassword);
            this.runExternal(cmd);
        }
    }

    public String getArchiveLocation(String pathToTest) {
        String pathToArchive = FilenameUtils.concat((String)pathToTest, (String)FilenameUtils.getFullPath((String)this.fBPELFilePath));
        String archiveName = FilenameUtils.getName((String)this.fBPELFilePath);
        return FilenameUtils.concat((String)pathToArchive, (String)archiveName);
    }

    public void setArchiveLocation(String archive) {
        this.fBPELFilePath = archive;
    }

    private void runExternal(String[] cmd) throws DeploymentException {
        try {
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(cmd);
            StreamReader errorReader = new StreamReader(proc.getErrorStream());
            StreamReader outputReader = new StreamReader(proc.getInputStream());
            errorReader.start();
            outputReader.start();
            int exitVal = proc.waitFor();
            if (exitVal != 0) {
                String lastLine = errorReader.getAsString();
                String errorMessage = lastLine != null && !lastLine.equals("") ? lastLine : "An unknown error occurred while deploying.";
                throw new DeploymentException(errorMessage);
            }
        }
        catch (IOException e) {
            throw new DeploymentException("Error during deployment", e);
        }
        catch (InterruptedException e) {
            throw new DeploymentException("Error during deployment", e);
        }
    }

    private String[] generateDeploy(String script, String processName, String processUrl, String domain, String password) {
        String[] cmd = new String[]{script, this.fBinDir, KEYWORD_DEPLOY, processName, processUrl, domain, password};
        return cmd;
    }

    private String[] generateUndeploy(String script, String processName, String domain, String password) {
        String[] cmd = new String[]{script, this.fBinDir, KEYWORD_UNDEPLOY, processName, domain, password};
        return cmd;
    }

    private void check(String toCheck, String description) throws DeploymentException {
        if (toCheck == null) {
            throw new DeploymentException("Oracle deployment configuration is missing the " + description + ".");
        }
    }

    public IDeployment getDeployment(ProcessUnderTest processUnderTest) throws DeploymentException {
        return null;
    }

    public void cleanUpAfterTestCase() {
    }
}

