/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.util.schema.nodes.impl;

import javax.xml.namespace.QName;
import net.bpelunit.toolsupport.util.schema.nodes.SchemaNode;
import org.junit.Assert;
import org.junit.Test;

public abstract class SchemaNodeTestAbstract {
    private String targetNs = "http://own.namespace.org/test";
    private String localPart = "PersonenType";
    private QName qName = new QName(this.targetNs, this.localPart);

    protected abstract SchemaNode constructSchemaNode(QName var1);

    protected abstract SchemaNode constructSchemaNode(String var1, String var2);

    @Test
    public void testSchemaNodeImplQName() {
        SchemaNode node = this.constructSchemaNode(this.qName);
        Assert.assertEquals((Object)this.qName, (Object)node.getQName());
        Assert.assertEquals((Object)this.targetNs, (Object)node.getNamespace());
        Assert.assertEquals((Object)this.localPart, (Object)node.getLocalPart());
    }

    @Test
    public void testSchemaNodeImplStringString() {
        SchemaNode node = this.constructSchemaNode(this.targetNs, this.localPart);
        Assert.assertEquals((Object)this.qName, (Object)node.getQName());
        Assert.assertEquals((Object)this.targetNs, (Object)node.getNamespace());
        Assert.assertEquals((Object)this.localPart, (Object)node.getLocalPart());
    }

    @Test
    public void testNullTargetNamespace() throws Exception {
        SchemaNode node = this.constructSchemaNode(null, this.localPart);
        Assert.assertEquals(null, (Object)node.getNamespace());
        Assert.assertEquals((Object)this.localPart, (Object)node.getLocalPart());
        Assert.assertEquals((Object)new QName("", this.localPart), (Object)node.getQName());
    }
}

