/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.util.schema.nodes.impl;

import java.io.File;
import java.util.HashMap;
import javax.xml.namespace.QName;
import net.bpelunit.toolsupport.util.schema.SchemaParser;
import net.bpelunit.toolsupport.util.schema.nodes.Element;
import net.bpelunit.toolsupport.util.schema.nodes.SchemaNode;
import net.bpelunit.toolsupport.util.schema.nodes.impl.ElementImpl;
import net.bpelunit.toolsupport.util.schema.nodes.impl.SchemaNodeTestAbstract;
import net.bpelunit.toolsupport.util.schema.nodes.impl.SimpleTypeImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ElementImplTest
extends SchemaNodeTestAbstract {
    private Element element;

    @Before
    public void setUp() throws Exception {
        this.element = new ElementImpl("http://www.Test.org", "vorname");
    }

    @Test
    public void testSetType() {
        SimpleTypeImpl simple = new SimpleTypeImpl("string");
        this.element.setType(simple);
        Assert.assertEquals((Object)simple, (Object)this.element.getType());
    }

    @Test
    public void testSetMinOccurs() {
        Assert.assertEquals((long)1L, (long)this.element.getMinOccurs());
        this.element.setMinOccurs(0);
        Assert.assertEquals((long)0L, (long)this.element.getMinOccurs());
        this.element.setMinOccurs(10);
        Assert.assertEquals((long)10L, (long)this.element.getMinOccurs());
        this.element.setMinOccurs(-1);
        Assert.assertEquals((long)0L, (long)this.element.getMinOccurs());
    }

    @Test
    public void testSetMaxOccurs() {
        Assert.assertEquals((long)1L, (long)this.element.getMaxOccurs());
        this.element.setMaxOccurs(0);
        Assert.assertEquals((long)0L, (long)this.element.getMaxOccurs());
        this.element.setMaxOccurs(5);
        Assert.assertEquals((long)5L, (long)this.element.getMaxOccurs());
        this.element.setMaxOccurs(-5);
        Assert.assertEquals((long)0L, (long)this.element.getMaxOccurs());
    }

    @Test
    public void testSetDefaultValue() {
        this.element.setDefaultValue("1");
        Assert.assertEquals((Object)"1", (Object)this.element.getDefaultValue());
        Assert.assertNull((String)"fixedValue has to be null", (Object)this.element.getFixedValue());
        this.element.setFixedValue("-1");
        Assert.assertNull((String)"defaultValue has to be null", (Object)this.element.getDefaultValue());
        this.element.setDefaultValue(null);
        Assert.assertEquals((Object)"-1", (Object)this.element.getFixedValue());
        this.element.setDefaultValue("1");
        this.element.setDefaultValue(null);
        Assert.assertNull((String)"defaultValue has to be null", (Object)this.element.getDefaultValue());
    }

    @Test
    public void testSetFixedValue() {
        this.element.setFixedValue("1000");
        Assert.assertEquals((Object)"1000", (Object)this.element.getFixedValue());
        Assert.assertNull((String)"defaultValue has to be null", (Object)this.element.getDefaultValue());
        this.element.setDefaultValue("1");
        Assert.assertNull((String)"fixedValue has to be null", (Object)this.element.getFixedValue());
        this.element.setFixedValue(null);
        Assert.assertEquals((Object)"1", (Object)this.element.getDefaultValue());
        this.element.setFixedValue("1");
        this.element.setFixedValue(null);
        Assert.assertNull((String)"fixedValue has to be null", (Object)this.element.getFixedValue());
    }

    @Test
    public void testToXMLString() throws Exception {
        SchemaParser parser = new SchemaParser();
        parser.parse(new File("testSchemata/defineComplexElements3.xsd"));
        String namespace = "http://schematest.bpelunit.org";
        this.element = parser.getElements().get(new QName(namespace, "employee"));
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put(namespace, "tes");
        String actual = this.element.toXMLString(namespaces);
        String expected = "<tes:employee lang=\"DE\" personId=\"-1\">\n\t<tes:firstname></tes:firstname>\n\t<tes:lastname></tes:lastname>\n\t<tes:location>\n\t\t<tes:city></tes:city>\n\t\t<tes:zip></tes:zip>\n\t</tes:location>\n\t<tes:location>\n\t\t<tes:city></tes:city>\n\t\t<tes:zip></tes:zip>\n\t</tes:location>\n</tes:employee>";
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Override
    protected SchemaNode constructSchemaNode(QName name) {
        return new ElementImpl(name);
    }

    @Override
    protected SchemaNode constructSchemaNode(String targetNs, String localPart) {
        return new ElementImpl(targetNs, localPart);
    }
}

