/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.editors.wizards.pages;

import net.bpelunit.framework.xml.suite.XMLSendActivity;
import net.bpelunit.framework.xml.suite.XMLTestSuite;
import net.bpelunit.toolsupport.editors.wizards.ActivityEditMode;
import net.bpelunit.toolsupport.editors.wizards.ActivityWizard;
import net.bpelunit.toolsupport.editors.wizards.WizardPageCode;
import net.bpelunit.toolsupport.editors.wizards.components.IComponentListener;
import net.bpelunit.toolsupport.editors.wizards.components.MessageChangeListener;
import net.bpelunit.toolsupport.editors.wizards.components.SendComponent;
import net.bpelunit.toolsupport.editors.wizards.fields.DialogField;
import net.bpelunit.toolsupport.editors.wizards.pages.ActivityWizardPage;
import net.bpelunit.toolsupport.util.ToolUtil;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;

public class SendSimpleWizardPage
extends ActivityWizardPage
implements IComponentListener {
    private SendComponent fSendComponent;
    private XMLSendActivity fSendActivity;

    public SendSimpleWizardPage(XMLSendActivity sendActivity, ActivityEditMode mode, String pageName) {
        super(pageName, mode);
        this.setDescription("Enter the data to be sent.");
        this.fSendActivity = sendActivity;
    }

    @Override
    protected void createFieldControls(Composite composite, int nColumns) {
        this.fSendComponent = new SendComponent((IWizardPage)this, this.getFontMetrics());
        this.fSendComponent.init(this.fSendActivity);
        this.fSendComponent.createControls(composite, nColumns);
        this.fSendComponent.addComponentListener(this);
        this.valueChanged(null);
    }

    @Override
    public void valueChanged(DialogField field) {
        if (this.fSendComponent != null) {
            String xmlText = this.fSendComponent.getXmlText();
            try {
                ToolUtil.parseSendBlockWithException(this.getTestSuite(), xmlText);
            }
            catch (Exception e) {
                this.setErrorMessage("Not valid XML: " + e.getMessage());
                this.setPageComplete(false);
                return;
            }
            String delaySequence = this.fSendComponent.getDelaySequence().trim();
            if (!"".equals(delaySequence)) {
                String[] sequence;
                String[] stringArray = sequence = delaySequence.split(",");
                int n = sequence.length;
                int n2 = 0;
                while (n2 < n) {
                    String element = stringArray[n2];
                    try {
                        Integer.parseInt(element.trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.fail("Delay Sequence must be a comma-separate integer list.");
                        return;
                    }
                    ++n2;
                }
            }
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    private void fail(String string) {
        this.setErrorMessage(string);
        this.setPageComplete(false);
    }

    private XMLTestSuite getTestSuite() {
        return ((ActivityWizard)this.getWizard()).getEditor().getTestSuite();
    }

    public String getSendXML() {
        return this.fSendComponent.getXmlText();
    }

    public String getDelaySequence() {
        return this.fSendComponent.getDelaySequence();
    }

    @Override
    public WizardPageCode getCode() {
        return WizardPageCode.SEND;
    }

    public MessageChangeListener getOperationChangeListener() {
        return this.fSendComponent;
    }
}

