/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.editors.wizards.fields;

import net.bpelunit.toolsupport.editors.wizards.fields.DialogField;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class StringDialogField
extends DialogField {
    private String fText = "";
    private Text fTextControl;
    private ModifyListener fModifyListener;
    private boolean fSkipLabel;

    public StringDialogField() {
    }

    public StringDialogField(boolean skipLabel) {
        this.fSkipLabel = skipLabel;
    }

    @Override
    public Control[] doFillIntoGrid(Composite parent, int nColumns) {
        Control[] controlArray;
        this.assertEnoughColumns(nColumns);
        Label label = null;
        if (!this.fSkipLabel) {
            label = this.getLabelControl(parent);
            label.setLayoutData((Object)StringDialogField.gridDataForLabel(1));
        }
        Text text = this.getTextControl(parent);
        text.setLayoutData((Object)StringDialogField.gridDataForText(nColumns - (this.fSkipLabel ? 0 : 1)));
        if (this.fSkipLabel) {
            Control[] controlArray2 = new Control[1];
            controlArray = controlArray2;
            controlArray2[0] = text;
        } else {
            Control[] controlArray3 = new Control[2];
            controlArray3[0] = label;
            controlArray = controlArray3;
            controlArray3[1] = text;
        }
        return controlArray;
    }

    @Override
    public int getNumberOfControls() {
        return this.fSkipLabel ? 1 : 2;
    }

    protected static GridData gridDataForText(int span) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        return gd;
    }

    @Override
    public boolean setFocus() {
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.fTextControl.setFocus();
            this.fTextControl.setSelection(0, this.fTextControl.getText().length());
        }
        return true;
    }

    public Text getTextControl(Composite parent) {
        if (this.fTextControl == null) {
            this.assertCompositeNotNull(parent);
            this.fModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    StringDialogField.this.doModifyText(e);
                }
            };
            this.fTextControl = new Text(parent, 2052);
            this.fTextControl.setText(this.fText);
            this.fTextControl.setFont(parent.getFont());
            this.fTextControl.addModifyListener(this.fModifyListener);
            this.fTextControl.setEnabled(this.isEnabled());
        }
        return this.fTextControl;
    }

    private void doModifyText(ModifyEvent e) {
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.fText = this.fTextControl.getText();
        }
        this.dialogFieldChanged();
    }

    @Override
    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.fTextControl.setEnabled(this.isEnabled());
        }
    }

    public String getText() {
        return this.fText;
    }

    public void setText(String text) {
        this.fText = text;
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.fTextControl.setText(text);
        } else {
            this.dialogFieldChanged();
        }
    }

    public void setTextWithoutUpdate(String text) {
        this.fText = text;
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.fTextControl.removeModifyListener(this.fModifyListener);
            this.fTextControl.setText(text);
            this.fTextControl.addModifyListener(this.fModifyListener);
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.setTextWithoutUpdate(this.fText);
        }
    }
}

