/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.editors.wizards.components;

import java.util.ArrayList;
import java.util.List;
import net.bpelunit.framework.xml.suite.XMLTestSuite;
import net.bpelunit.toolsupport.editors.BPELUnitEditor;
import net.bpelunit.toolsupport.editors.wizards.ActivityWizard;
import net.bpelunit.toolsupport.editors.wizards.components.IComponentListener;
import net.bpelunit.toolsupport.editors.wizards.fields.DialogField;
import net.bpelunit.toolsupport.editors.wizards.pages.ActivityWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class DataComponent {
    private List<IComponentListener> fListeners;
    private FontMetrics fFontMetrics;
    private IWizardPage fWizardPage;

    public DataComponent(IWizardPage page, FontMetrics metrics) {
        this.fWizardPage = page;
        this.fFontMetrics = metrics;
        this.fListeners = new ArrayList<IComponentListener>();
    }

    public void addComponentListener(IComponentListener listener) {
        this.fListeners.add(listener);
    }

    public void removeComponentListener(IComponentListener listener) {
        this.fListeners.remove(listener);
    }

    protected void fireValueChanged(DialogField field) {
        for (IComponentListener listener : this.fListeners) {
            listener.valueChanged(field);
        }
    }

    protected int getMaxFieldWidth() {
        return Dialog.convertWidthInCharsToPixels((FontMetrics)this.fFontMetrics, (int)40);
    }

    protected Group createGroup(Composite composite, String title, int nColumns, GridData gd) {
        Group operationGroup = new Group(composite, 0);
        operationGroup.setText(title);
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        operationGroup.setLayout((Layout)layout);
        gd.horizontalSpan = 4;
        operationGroup.setLayoutData((Object)gd);
        return operationGroup;
    }

    public abstract Composite createControls(Composite var1, int var2);

    protected FontMetrics getFontMetrics() {
        return this.fFontMetrics;
    }

    protected BPELUnitEditor getEditor() {
        return this.getWizard().getEditor();
    }

    protected XMLTestSuite getTestSuite() {
        return this.getEditor().getTestSuite();
    }

    protected ActivityWizardPage getWizardPage() {
        return (ActivityWizardPage)this.fWizardPage;
    }

    protected ActivityWizard getWizard() {
        return (ActivityWizard)this.fWizardPage.getWizard();
    }

    protected Shell getShell() {
        return this.fWizardPage.getControl().getShell();
    }
}

