/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.editors.sections;

import java.util.ArrayList;
import java.util.List;
import net.bpelunit.framework.client.eclipse.dialog.DialogFieldValidator;
import net.bpelunit.framework.client.eclipse.dialog.Field;
import net.bpelunit.framework.client.eclipse.dialog.FieldBasedInputDialog;
import net.bpelunit.framework.client.eclipse.dialog.field.FileField;
import net.bpelunit.framework.client.eclipse.dialog.field.TextField;
import net.bpelunit.framework.client.eclipse.dialog.validate.NotEmptyValidator;
import net.bpelunit.framework.xml.suite.XMLAbstractDeploymentInformation;
import net.bpelunit.framework.xml.suite.XMLDeploymentSection;
import net.bpelunit.framework.xml.suite.XMLHumanPartnerDeploymentInformation;
import net.bpelunit.framework.xml.suite.XMLHumanPartnerTrack;
import net.bpelunit.framework.xml.suite.XMLPartnerDeploymentInformation;
import net.bpelunit.framework.xml.suite.XMLPartnerTrack;
import net.bpelunit.framework.xml.suite.XMLTestCase;
import net.bpelunit.framework.xml.suite.XMLTestSuite;
import net.bpelunit.toolsupport.ToolSupportActivator;
import net.bpelunit.toolsupport.editors.TestSuitePage;
import net.bpelunit.toolsupport.editors.sections.ListSection;
import net.bpelunit.toolsupport.util.WSDLFileFilter;
import net.bpelunit.toolsupport.util.WSDLFileValidator;
import net.bpelunit.toolsupport.util.WSDLReadingException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class PartnerSection
extends ListSection {
    private static final String OPTION_WSDL_FILE = "WSDL file";
    private static final String OPTION_PARTNER_WSDL_FILE = "Partner WSDL file";
    private static final String OPTION_NAME = "Name";
    private static final String OPTION_WSHTENDPOINT = "WS-HT Endpoint";
    private static final String OPTION_USERNAME = "User Name";
    private static final String OPTION_PASSWORD = "Password";

    public PartnerSection(Composite parent, TestSuitePage page, FormToolkit toolkit) {
        super(parent, toolkit, page, false, false, "Add &WS-HT Track...");
        this.init();
    }

    private void init() {
        this.getViewer().setLabelProvider((IBaseLabelProvider)new PartnerLabelProvider());
        this.getViewer().setContentProvider((IContentProvider)new PartnerContentProvider());
    }

    @Override
    protected String getDescription() {
        return "Manage the partner processes.";
    }

    @Override
    protected String getName() {
        return "Partners";
    }

    public void refresh() {
        this.setViewerInput(this.getDeploymentXMLPart());
        super.refresh();
    }

    private XMLDeploymentSection getDeploymentXMLPart() {
        XMLTestSuite model = this.getTestSuite();
        return model.getDeployment();
    }

    @Override
    public void createClient(Section section, FormToolkit toolkit) {
        super.createClient(section, toolkit);
    }

    @Override
    protected void addPressed() {
        PartnerPropertiesDialog dialog = new PartnerPropertiesDialog(this.getShell(), "Add a partner");
        if (dialog.open() != 0) {
            return;
        }
        XMLPartnerDeploymentInformation information = this.getDeploymentXMLPart().addNewPartner();
        String partnerName = dialog.getPartnerName();
        if (partnerName != null) {
            partnerName = partnerName.trim();
        }
        information.setName(partnerName);
        this.addPartnerTrackToAllTestCases((XMLAbstractDeploymentInformation)information);
        this.updateValuesToModel(information, dialog);
    }

    @Override
    protected void add2Pressed() {
        HumanPartnerPropertiesDialog dialog = new HumanPartnerPropertiesDialog(this.getShell(), "Add a partner");
        if (dialog.open() != 0) {
            return;
        }
        XMLHumanPartnerDeploymentInformation information = this.getDeploymentXMLPart().addNewHumanPartner();
        String partnerName = dialog.getPartnerName();
        if (partnerName != null) {
            partnerName = partnerName.trim();
        }
        information.setName(partnerName);
        this.addPartnerTrackToAllTestCases((XMLAbstractDeploymentInformation)information);
        this.updateValuesToModel(information, dialog);
    }

    private void addPartnerTrackToAllTestCases(XMLAbstractDeploymentInformation partner) {
        List testCases = this.getEditor().getTestSuite().getTestCases().getTestCaseList();
        if (partner instanceof XMLPartnerDeploymentInformation) {
            for (XMLTestCase testCase : testCases) {
                testCase.addNewPartnerTrack().setName(partner.getName());
            }
        } else {
            for (XMLTestCase testCase : testCases) {
                testCase.addNewHumanPartnerTrack().setName(partner.getName());
            }
        }
    }

    @Override
    protected void editPressed() {
        FieldBasedInputDialog dialog;
        XMLPartnerDeploymentInformation currentPartner;
        XMLAbstractDeploymentInformation currentlySelectedItem = this.getCurrentlySelectedItem();
        if (currentlySelectedItem instanceof XMLPartnerDeploymentInformation) {
            currentPartner = (XMLPartnerDeploymentInformation)currentlySelectedItem;
            dialog = new PartnerPropertiesDialog(this.getShell(), "Edit a partner", currentPartner.getName(), currentPartner.getWsdl(), currentPartner.getPartnerWsdl());
            if (dialog.open() != 0) {
                return;
            }
            this.changePartnerTrackNameInAllTestCases(currentlySelectedItem.getName(), dialog.getPartnerName().trim());
            this.updateValuesToModel(currentPartner, (PartnerPropertiesDialog)dialog);
        }
        if (currentlySelectedItem instanceof XMLHumanPartnerDeploymentInformation) {
            currentPartner = (XMLHumanPartnerDeploymentInformation)currentlySelectedItem;
            dialog = new HumanPartnerPropertiesDialog(this.getShell(), "Edit a partner", currentPartner.getName(), currentPartner.getWshtEndpoint(), currentPartner.getUsername(), currentPartner.getPassword());
            if (dialog.open() != 0) {
                return;
            }
            this.changePartnerTrackNameInAllTestCases(currentlySelectedItem.getName(), dialog.getPartnerName());
            this.updateValuesToModel((XMLHumanPartnerDeploymentInformation)currentPartner, (HumanPartnerPropertiesDialog)dialog);
        }
    }

    private void changePartnerTrackNameInAllTestCases(String oldName, String newName) {
        if (!oldName.equals(newName)) {
            List testCases = this.getEditor().getTestSuite().getTestCases().getTestCaseList();
            for (XMLTestCase testCase : testCases) {
                this.renamePartnerInTestCase(oldName, newName, testCase);
            }
        }
    }

    private void renamePartnerInTestCase(String oldName, String newName, XMLTestCase testCase) {
        List partnerTracks = testCase.getPartnerTrackList();
        for (XMLPartnerTrack pt : partnerTracks) {
            if (!oldName.equals(pt.getName())) continue;
            pt.setName(newName);
            break;
        }
        List humanPartnerTracks = testCase.getHumanPartnerTrackList();
        for (XMLHumanPartnerTrack pt : humanPartnerTracks) {
            if (!oldName.equals(pt.getName())) continue;
            pt.setName(newName);
            break;
        }
    }

    private void updateValuesToModel(XMLPartnerDeploymentInformation modelItem, PartnerPropertiesDialog dialog) {
        String name = dialog.getPartnerName();
        String wsdlFileName = dialog.getWSDLFileName();
        String partnerWSDLFileName = dialog.getPartnerWSDLFileName();
        if (name != null && wsdlFileName != null && name.length() > 0 && wsdlFileName.length() > 0) {
            modelItem.setName(name.trim());
            modelItem.setWsdl(wsdlFileName);
            this.manageTargetNamespace(wsdlFileName);
            if (partnerWSDLFileName != null && !"".equals(partnerWSDLFileName)) {
                modelItem.setPartnerWsdl(partnerWSDLFileName);
                this.manageTargetNamespace(partnerWSDLFileName);
            } else {
                modelItem.setPartnerWsdl(null);
            }
            this.getEditor().refresh();
            this.markDirty();
        }
    }

    private void updateValuesToModel(XMLHumanPartnerDeploymentInformation modelItem, HumanPartnerPropertiesDialog dialog) {
        String name = dialog.getPartnerName();
        String wshtEndpoint = dialog.getWSHTEndpoint();
        String username = dialog.getUsername();
        String password = dialog.getPassword();
        if (name != null && wshtEndpoint != null && name.length() > 0 && wshtEndpoint.length() > 0 && username != null && username.length() > 0 && password != null && password.length() > 0) {
            modelItem.setName(name);
            modelItem.setWshtEndpoint(wshtEndpoint);
            modelItem.setUsername(username);
            modelItem.setPassword(password);
            this.getEditor().refresh();
            this.markDirty();
        }
    }

    @Override
    protected void removePressed() {
        XMLAbstractDeploymentInformation currentlySelectedItem = this.getCurrentlySelectedItem();
        this.removePartnerFromTestCases(currentlySelectedItem.getName());
        this.removePartner(currentlySelectedItem);
        this.getEditor().refresh();
        this.setEditRemoveDuplicateEnabled(false);
        this.markDirty();
    }

    private void removePartnerFromTestCases(String name) {
        List testCases = this.getEditor().getTestSuite().getTestCases().getTestCaseList();
        block0: for (XMLTestCase tc : testCases) {
            List partnerTracks = tc.getPartnerTrackList();
            int i = 0;
            while (i < partnerTracks.size()) {
                XMLPartnerTrack pt = (XMLPartnerTrack)partnerTracks.get(i);
                if (name.equals(pt.getName())) {
                    tc.removePartnerTrack(i);
                    break;
                }
                ++i;
            }
            List humanPartnerTracks = tc.getHumanPartnerTrackList();
            int i2 = 0;
            while (i2 < humanPartnerTracks.size()) {
                XMLHumanPartnerTrack pt = (XMLHumanPartnerTrack)humanPartnerTracks.get(i2);
                if (name.equals(pt.getName())) {
                    tc.removeHumanPartnerTrack(i2);
                    continue block0;
                }
                ++i2;
            }
        }
    }

    private void removePartner(XMLAbstractDeploymentInformation currentlySelectedItem) {
        List partnerList = this.getDeploymentXMLPart().getPartnerList();
        int i = 0;
        while (i < partnerList.size()) {
            if (((XMLPartnerDeploymentInformation)partnerList.get(i)).equals(currentlySelectedItem)) {
                this.getDeploymentXMLPart().removePartner(i);
                break;
            }
            ++i;
        }
        List humanPartnerList = this.getDeploymentXMLPart().getHumanPartnerList();
        int i2 = 0;
        while (i2 < humanPartnerList.size()) {
            if (((XMLHumanPartnerDeploymentInformation)humanPartnerList.get(i2)).equals(currentlySelectedItem)) {
                this.getDeploymentXMLPart().removeHumanPartner(i2);
                break;
            }
            ++i2;
        }
    }

    private XMLAbstractDeploymentInformation getCurrentlySelectedItem() {
        return (XMLAbstractDeploymentInformation)this.getViewerSelection();
    }

    @Override
    protected void itemSelected(Object item) {
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        MenuManager newMenu = new MenuManager("&New");
        this.createAction((IMenuManager)newMenu, "Partner", new Action(){

            public void run() {
                PartnerSection.this.addPressed();
            }
        });
        manager.add((IContributionItem)newMenu);
        ISelection selection = this.getViewer().getSelection();
        IStructuredSelection ssel = (IStructuredSelection)selection;
        if (ssel.size() == 1) {
            manager.add((IContributionItem)new Separator());
            this.createAction(manager, "&Edit", new Action(){

                public void run() {
                    PartnerSection.this.editPressed();
                }
            });
            manager.add((IContributionItem)new Separator());
            this.createAction(manager, "&Remove", new Action(){

                public void run() {
                    PartnerSection.this.removePressed();
                }
            });
        }
    }

    private class HumanPartnerPropertiesDialog
    extends FieldBasedInputDialog {
        private TextField nameField;
        private TextField wsthtEndpointField;
        private TextField usernameField;
        private TextField passwordField;

        public HumanPartnerPropertiesDialog(Shell parent, String title) {
            this(parent, title, "", null, null, null);
        }

        public HumanPartnerPropertiesDialog(Shell shell, String title, String partnerName, String wshtEndpoint, String username, String password) {
            super(shell, title);
            this.nameField = new TextField((FieldBasedInputDialog)this, PartnerSection.OPTION_NAME, partnerName, TextField.Style.SINGLE);
            this.nameField.setValidator((DialogFieldValidator)new NotEmptyValidator("Partner Name"));
            this.addField((Field)this.nameField);
            this.wsthtEndpointField = new TextField((FieldBasedInputDialog)this, PartnerSection.OPTION_WSHTENDPOINT, wshtEndpoint, TextField.Style.SINGLE);
            this.wsthtEndpointField.setValidator((DialogFieldValidator)new NotEmptyValidator(PartnerSection.OPTION_WSHTENDPOINT));
            this.addField((Field)this.wsthtEndpointField);
            this.usernameField = new TextField((FieldBasedInputDialog)this, PartnerSection.OPTION_USERNAME, username, TextField.Style.SINGLE);
            this.usernameField.setValidator((DialogFieldValidator)new NotEmptyValidator("WS-HT User"));
            this.addField((Field)this.usernameField);
            this.passwordField = new TextField((FieldBasedInputDialog)this, PartnerSection.OPTION_PASSWORD, password, TextField.Style.SINGLE);
            this.passwordField.setValidator((DialogFieldValidator)new NotEmptyValidator(PartnerSection.OPTION_PASSWORD));
            this.passwordField.setEchoChar('*');
            this.addField((Field)this.passwordField);
        }

        public String getPartnerName() {
            return this.nameField.getSelection();
        }

        public String getWSHTEndpoint() {
            return this.wsthtEndpointField.getSelection();
        }

        public String getUsername() {
            return this.usernameField.getSelection();
        }

        public String getPassword() {
            return this.passwordField.getSelection();
        }
    }

    private class PartnerContentProvider
    implements IStructuredContentProvider {
        private PartnerContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof XMLDeploymentSection) {
                XMLDeploymentSection element = (XMLDeploymentSection)inputElement;
                ArrayList partners = new ArrayList();
                partners.addAll(element.getPartnerList());
                partners.addAll(element.getHumanPartnerList());
                return partners.toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class PartnerLabelProvider
    implements ILabelProvider {
        private PartnerLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof XMLHumanPartnerDeploymentInformation) {
                return ToolSupportActivator.getImage("img_deployer");
            }
            return ToolSupportActivator.getImage("img_deployer");
        }

        public String getText(Object element) {
            if (element instanceof XMLAbstractDeploymentInformation) {
                return ((XMLAbstractDeploymentInformation)element).getName();
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class PartnerPropertiesDialog
    extends FieldBasedInputDialog {
        private FileField wsdlFileField;
        private TextField nameField;
        private FileField partnerWSDLFileField;

        public PartnerPropertiesDialog(Shell parent, String title) {
            this(parent, title, "", null, null);
        }

        public PartnerPropertiesDialog(Shell parent, String title, String partnerName, String wsdlFileName, String partnerWSDLFileName) {
            super(parent, title);
            this.nameField = new TextField((FieldBasedInputDialog)this, PartnerSection.OPTION_NAME, partnerName, TextField.Style.SINGLE);
            this.nameField.setValidator((DialogFieldValidator)new NotEmptyValidator(PartnerSection.OPTION_NAME));
            this.addField((Field)this.nameField);
            this.wsdlFileField = new FileField((FieldBasedInputDialog)this, PartnerSection.OPTION_WSDL_FILE, wsdlFileName, (ISelectionStatusValidator)new WSDLFileValidator(PartnerSection.this.getEditor()), (ViewerFilter)new WSDLFileFilter(), PartnerSection.this.getEditor().getCurrentProject(), PartnerSection.this.getEditor().getCurrentDirectory());
            this.wsdlFileField.setValidator((DialogFieldValidator)new WsdlValidator());
            this.addField((Field)this.wsdlFileField);
            this.partnerWSDLFileField = new FileField((FieldBasedInputDialog)this, PartnerSection.OPTION_PARTNER_WSDL_FILE, partnerWSDLFileName, (ISelectionStatusValidator)new WSDLFileValidator(PartnerSection.this.getEditor(), false), (ViewerFilter)new WSDLFileFilter(), PartnerSection.this.getEditor().getCurrentProject(), PartnerSection.this.getEditor().getCurrentDirectory());
            this.partnerWSDLFileField.setValidator((DialogFieldValidator)new WsdlValidator(false));
            this.addField((Field)this.partnerWSDLFileField);
        }

        public String getPartnerName() {
            return this.nameField.getSelection();
        }

        public String getWSDLFileName() {
            return this.wsdlFileField.getSelection();
        }

        public String getPartnerWSDLFileName() {
            return this.partnerWSDLFileField.getSelection();
        }
    }

    private class WsdlValidator
    extends DialogFieldValidator {
        private boolean required;

        public WsdlValidator() {
            this(true);
        }

        public WsdlValidator(boolean required) {
            this.required = required;
        }

        public String validate(String value) {
            if (!this.required) {
                return null;
            }
            if ("".equals(value)) {
                return "WSDL file must be specified.";
            }
            try {
                PartnerSection.this.getEditor().getWsdlForFile(value);
            }
            catch (WSDLReadingException e) {
                String msg = String.valueOf(e.getMessage()) + (e.getCause() != null ? ": " + e.getCause() : "");
                return msg;
            }
            return null;
        }
    }
}

