/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.editors.formwidgets;

import net.bpelunit.toolsupport.editors.formwidgets.IEntryListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class TextEntry {
    private Control label;
    private Control text;
    private String value = "";
    private boolean dirty;
    boolean ignoreModify = false;
    private IEntryListener listener;

    public TextEntry(Composite parent, FormToolkit toolkit, String labelText, int style) {
        this.createControl(parent, toolkit, labelText, style);
    }

    private void createControl(Composite parent, FormToolkit toolkit, String labelText, int style) {
        this.label = toolkit.createLabel(parent, labelText);
        this.label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.text = this.createEntry(parent, toolkit, style);
        this.addListeners();
        this.layout(parent);
    }

    protected Control createEntry(Composite parent, FormToolkit toolkit, int style) {
        return toolkit.createText(parent, "", style);
    }

    private void layout(Composite parent) {
        Layout layout = parent.getLayout();
        if (layout instanceof TableWrapLayout) {
            int span = ((TableWrapLayout)layout).numColumns;
            TableWrapData td = new TableWrapData();
            td.valign = (this.text.getStyle() & 2) != 0 ? 16 : 32;
            this.label.setLayoutData((Object)td);
            int tspan = span - 1;
            td = new TableWrapData(128);
            td.colspan = tspan;
            boolean bl = td.grabHorizontal = tspan == 1;
            if ((this.text.getStyle() & 2) != 0) {
                td.valign = 128;
                td.heightHint = 80;
            } else {
                td.valign = 32;
            }
            this.text.setLayoutData((Object)td);
        }
    }

    public void setFormEntryListener(IEntryListener listener) {
        this.listener = listener;
    }

    private void addListeners() {
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                TextEntry.this.keyReleaseOccured(e);
            }
        });
        this.addModifyListener(this.text);
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (TextEntry.this.dirty) {
                    TextEntry.this.commit();
                }
            }
        });
    }

    private void addModifyListener(Control text2) {
        if (text2 instanceof Text) {
            ((Text)this.text).addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    TextEntry.this.editOccured(e);
                }
            });
        } else if (text2 instanceof Combo) {
            ((Combo)this.text).addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    TextEntry.this.editOccured(e);
                }
            });
        }
    }

    public void commit() {
        if (this.dirty) {
            this.value = this.getText(this.text);
            if (this.listener != null) {
                this.listener.textValueChanged(this);
            }
        }
        this.dirty = false;
    }

    private String getText(Control text2) {
        if (text2 instanceof Text) {
            return ((Text)this.text).getText();
        }
        if (text2 instanceof Combo) {
            return ((Combo)this.text).getText();
        }
        return "";
    }

    public void cancelEdit() {
        this.dirty = false;
    }

    private void editOccured(ModifyEvent e) {
        if (this.ignoreModify) {
            return;
        }
        this.dirty = true;
        if (this.listener != null) {
            this.listener.textDirty(this);
        }
    }

    public String getValue() {
        return this.value.trim();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private void keyReleaseOccured(KeyEvent e) {
        if (e.character == '\r') {
            if (this.dirty) {
                this.commit();
            }
        } else if (e.character == '\u001b') {
            this.setText(this.value != null ? this.value : "");
            this.dirty = false;
        }
    }

    private void setText(String string) {
        if (this.text instanceof Text) {
            ((Text)this.text).setText(string);
        } else if (this.text instanceof Combo) {
            ((Combo)this.text).setText(string);
        }
    }

    public void setValue(String value) {
        if (this.text != null) {
            this.setText(value != null ? value : "");
        }
        this.value = value != null ? value : "";
    }

    public void setValue(String value, boolean blockNotification) {
        this.ignoreModify = blockNotification;
        this.setValue(value);
        this.ignoreModify = false;
    }
}

