/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.model.test.data;

import com.rits.cloning.Cloner;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.SOAPMessage;
import net.bpelunit.framework.control.ext.ISOAPEncoder;
import net.bpelunit.framework.control.util.BPELUnitUtil;
import net.bpelunit.framework.control.util.XPathTool;
import net.bpelunit.framework.exception.HeaderProcessingException;
import net.bpelunit.framework.exception.SOAPEncodingException;
import net.bpelunit.framework.exception.SpecificationException;
import net.bpelunit.framework.model.test.activity.Activity;
import net.bpelunit.framework.model.test.activity.ActivityContext;
import net.bpelunit.framework.model.test.data.DataCopyOperation;
import net.bpelunit.framework.model.test.data.DataSpecification;
import net.bpelunit.framework.model.test.data.SOAPOperationCallIdentifier;
import net.bpelunit.framework.model.test.data.XMLData;
import net.bpelunit.framework.model.test.report.ArtefactStatus;
import net.bpelunit.framework.model.test.report.ITestArtefact;
import net.bpelunit.framework.model.test.report.StateData;
import org.apache.log4j.Logger;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class SendDataSpecification
extends DataSpecification {
    private SOAPOperationCallIdentifier fOperation;
    private String fEncodingStyle;
    private ISOAPEncoder fEncoder;
    private String fPlainMessage;
    private SOAPMessage fSOAPMessage;
    private Element fLiteralData;
    private String fSOAPHTTPAction;
    private String fTargetURL;
    private NamespaceContext fNamespaceContext;
    private int fDelay;
    private QName fFaultCode;
    private String fFaultString;
    private String fDataTemplate;
    private static final Cloner fCloner = new Cloner();

    public SendDataSpecification(Activity parent) throws SpecificationException {
        super(parent);
    }

    public void initialize(SOAPOperationCallIdentifier operation, int delay, String targetURL, String soapAction, String encodingStyle, ISOAPEncoder encoder, Element rawDataRoot, String dataTemplate, NamespaceContext context, QName faultCode, String faultString) {
        this.fOperation = operation;
        this.fLiteralData = rawDataRoot;
        this.fDataTemplate = dataTemplate;
        this.fNamespaceContext = context;
        this.fSOAPHTTPAction = soapAction;
        this.fTargetURL = targetURL;
        this.fEncodingStyle = encodingStyle;
        this.fEncoder = encoder;
        this.fDelay = delay;
        this.fFaultCode = faultCode;
        this.fFaultString = faultString;
    }

    public void handle(ActivityContext context) {
        if (this.fDataTemplate != null) {
            this.expandTemplate(context);
        }
        if (this.hasProblems()) {
            return;
        }
        this.insertMappingData(context);
        this.encodeMessage();
        if (this.hasProblems()) {
            return;
        }
        try {
            context.processHeaders(this);
        }
        catch (HeaderProcessingException e) {
            this.fStatus = ArtefactStatus.createErrorStatus("Header Processing Fault.", e);
            return;
        }
        if (this.hasProblems()) {
            return;
        }
        this.createWireFormat();
        if (this.hasProblems()) {
            return;
        }
        this.fStatus = ArtefactStatus.createPassedStatus();
    }

    private void expandTemplate(ActivityContext context) {
        try {
            VelocityContext velocityCtx = (VelocityContext)fCloner.deepClone((Object)context.createVelocityContext());
            velocityCtx.put("xpath", (Object)new XPathTool(this.fNamespaceContext));
            StringWriter writer = new StringWriter();
            Velocity.evaluate((Context)velocityCtx, (Writer)writer, (String)"expandTemplate", (String)this.fDataTemplate);
            String expandedTemplate = writer.toString();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            Document docExpanded = dbf.newDocumentBuilder().parse(new InputSource(new StringReader(expandedTemplate)));
            this.fLiteralData = docExpanded.getDocumentElement();
            context.saveSentMessage(this.fLiteralData);
        }
        catch (Exception ex) {
            this.fStatus = ArtefactStatus.createErrorStatus("Template expansion fault: " + ex.getLocalizedMessage(), ex);
        }
    }

    public void delay() throws InterruptedException {
        if (this.fDelay > 0) {
            Logger.getLogger(this.getClass()).info((Object)("Delaying send for " + this.fDelay + " seconds..."));
            Thread.sleep(this.fDelay * 1000);
        }
    }

    public String getTargetURL() {
        return this.fTargetURL;
    }

    public void setTargetURL(String targetURL) {
        this.fTargetURL = targetURL;
    }

    public String getSOAPHTTPAction() {
        return this.fSOAPHTTPAction;
    }

    public SOAPMessage getSOAPMessage() {
        return this.fSOAPMessage;
    }

    public String getInWireFormat() {
        return this.fPlainMessage;
    }

    public boolean isFault() {
        return this.fOperation.isFault();
    }

    private void insertMappingData(ActivityContext context) {
        List<DataCopyOperation> mapping = context.getMapping();
        if (mapping != null) {
            for (DataCopyOperation copy : mapping) {
                copy.setTextNodes(this.fLiteralData, this.fNamespaceContext);
                if (!copy.isError()) continue;
                this.fStatus = ArtefactStatus.createErrorStatus("An error occurred while evaluating Copy-To-XPath expression.");
                return;
            }
        }
    }

    private void encodeMessage() {
        try {
            this.fSOAPMessage = this.fEncoder.construct(this.fOperation, this.fLiteralData, this.fFaultCode, this.fFaultString);
        }
        catch (SOAPEncodingException e) {
            this.fStatus = ArtefactStatus.createErrorStatus("Encoding the message failed: " + e.getMessage(), e);
        }
    }

    private void createWireFormat() {
        try {
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            this.fSOAPMessage.writeTo((OutputStream)b);
            this.fPlainMessage = b.toString();
        }
        catch (Exception e) {
            this.fStatus = ArtefactStatus.createErrorStatus("Error serializing SOAP message: " + e.getMessage(), e);
        }
    }

    private String getWireFormatAsString() {
        if (this.fPlainMessage != null) {
            return this.fPlainMessage;
        }
        return "(no data)";
    }

    private String getLiteralDataAsString() {
        if (this.fLiteralData != null) {
            return BPELUnitUtil.toFormattedString(this.fLiteralData.getOwnerDocument());
        }
        return "(no data)";
    }

    private String getSOAPMessageDataAsString() {
        if (this.fSOAPMessage != null) {
            return BPELUnitUtil.toFormattedString((Document)this.fSOAPMessage.getSOAPPart());
        }
        return "(no message)";
    }

    @Override
    public String getName() {
        return "Send Data Package";
    }

    @Override
    public List<ITestArtefact> getChildren() {
        ArrayList<ITestArtefact> returner = new ArrayList<ITestArtefact>();
        returner.add(new XMLData(this, "Literal XML data", this.getLiteralDataAsString()));
        returner.add(new XMLData(this, "SOAP Message data", this.getSOAPMessageDataAsString()));
        returner.add(new XMLData(this, "Plain outgoing message", this.getWireFormatAsString()));
        return returner;
    }

    @Override
    public List<StateData> getStateData() {
        ArrayList<StateData> stateData = new ArrayList<StateData>();
        stateData.addAll(this.fStatus.getAsStateData());
        if (this.fTargetURL != null) {
            stateData.add(new StateData("Target URL", this.fTargetURL));
            stateData.add(new StateData("HTTP Action", this.fSOAPHTTPAction));
        }
        stateData.add(new StateData("Style/Encoding", this.fEncodingStyle));
        stateData.add(new StateData("Direction", this.fOperation.getDirection().name()));
        return stateData;
    }
}

