/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.model.test.data;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import net.bpelunit.framework.control.util.BPELUnitUtil;
import net.bpelunit.framework.model.test.report.ArtefactStatus;
import net.bpelunit.framework.model.test.report.ITestArtefact;
import net.bpelunit.framework.model.test.report.StateData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DataCopyOperation
implements ITestArtefact {
    private String fFrom;
    private String fTo;
    private String fCopiedValue;
    private ITestArtefact fParent;
    private ArtefactStatus fStatus;

    public DataCopyOperation(ITestArtefact parent, String from, String to) {
        this.fFrom = from;
        this.fTo = to;
        this.fStatus = ArtefactStatus.createInitialStatus();
        this.fParent = parent;
    }

    public void retrieveTextNodes(Element literalData, NamespaceContext namespaceContext) {
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(namespaceContext);
        try {
            Node inputNode = (Node)xpath.evaluate(this.getFromXPath(), literalData, XPathConstants.NODE);
            if (inputNode != null) {
                Node inputTextNode = null;
                NodeList children = inputNode.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node node = children.item(i);
                    if (node.getNodeType() != 3) continue;
                    inputTextNode = node;
                }
                if (inputTextNode == null) {
                    this.fStatus = ArtefactStatus.createErrorStatus("Could not find a text node underneath node " + inputNode.getLocalName());
                } else {
                    this.fStatus = ArtefactStatus.createInProgressStatus();
                    this.setCopiedValue(inputTextNode.getNodeValue());
                }
            } else {
                this.fStatus = ArtefactStatus.createErrorStatus("XPath expression did not yield a result node.");
            }
        }
        catch (Exception e) {
            Throwable root = BPELUnitUtil.findRootThrowable(e);
            this.fStatus = ArtefactStatus.createErrorStatus("XPath Expression Exception when evaluating XPath: " + root.getMessage());
        }
    }

    public void setTextNodes(Element parent, NamespaceContext context) {
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(context);
        try {
            Node outputNode = (Node)xpath.evaluate(this.getToXPath(), parent, XPathConstants.NODE);
            if (outputNode != null) {
                Node outTextNode = null;
                NodeList children = outputNode.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node node = children.item(i);
                    if (node.getNodeType() != 3) continue;
                    outTextNode = node;
                }
                if (outTextNode == null) {
                    Text node = outputNode.getOwnerDocument().createTextNode(this.getCopiedValue());
                    outputNode.appendChild(node);
                } else {
                    outTextNode.setNodeValue(this.getCopiedValue());
                }
                this.fStatus = ArtefactStatus.createPassedStatus();
            } else {
                this.fStatus = ArtefactStatus.createErrorStatus("XPath expression did not yield a result node.");
            }
        }
        catch (Exception e) {
            Throwable root = BPELUnitUtil.findRootThrowable(e);
            this.fStatus = ArtefactStatus.createErrorStatus("XPath Expression Exception when evaluating XPath: " + root.getMessage());
        }
    }

    public String getFromXPath() {
        return this.fFrom;
    }

    public String getToXPath() {
        return this.fTo;
    }

    public void setCopiedValue(String value) {
        this.fCopiedValue = value;
    }

    public String getCopiedValue() {
        return this.fCopiedValue != null ? this.fCopiedValue : "(none)";
    }

    public boolean isFailure() {
        return this.fStatus.isFailure();
    }

    public boolean isError() {
        return this.fStatus.isError();
    }

    @Override
    public String getName() {
        return "Copy operation";
    }

    @Override
    public ITestArtefact getParent() {
        return this.fParent;
    }

    @Override
    public List<ITestArtefact> getChildren() {
        return new ArrayList<ITestArtefact>();
    }

    @Override
    public ArtefactStatus getStatus() {
        return this.fStatus;
    }

    @Override
    public List<StateData> getStateData() {
        ArrayList<StateData> stateData = new ArrayList<StateData>();
        stateData.addAll(this.fStatus.getAsStateData());
        stateData.add(new StateData("From expression", this.fFrom));
        stateData.add(new StateData("To expression", this.fTo));
        stateData.add(new StateData("Copy value", this.getCopiedValue()));
        return stateData;
    }

    @Override
    public void reportProgress(ITestArtefact artefact) {
        this.fParent.reportProgress(artefact);
    }

    public String toString() {
        StringBuffer r = new StringBuffer();
        r.append("Expression from: \"" + this.fFrom + "\" to: \"" + this.fTo + "\"");
        if (!this.fStatus.isInitial()) {
            r.append(" => Copied value: \"" + this.getCopiedValue() + "\"");
        }
        r.append(" => Evaluation: " + this.fStatus);
        return r.toString();
    }
}

