/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.model.test.activity;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import net.bpelunit.framework.model.test.PartnerTrack;
import net.bpelunit.framework.model.test.activity.Activity;
import net.bpelunit.framework.model.test.activity.ActivityContext;
import net.bpelunit.framework.model.test.activity.TwoWayAsyncActivity;
import net.bpelunit.framework.model.test.data.ReceiveDataSpecification;
import net.bpelunit.framework.model.test.report.ArtefactStatus;
import net.bpelunit.framework.model.test.report.ITestArtefact;
import net.bpelunit.framework.model.test.wire.IncomingMessage;
import net.bpelunit.framework.model.test.wire.OutgoingMessage;

public class ReceiveAsync
extends Activity {
    private TwoWayAsyncActivity fParentActivity;
    private ReceiveDataSpecification fReceiveSpec;

    public ReceiveAsync(PartnerTrack partnerTrack) {
        super(partnerTrack);
        this.fParentActivity = null;
    }

    public ReceiveAsync(TwoWayAsyncActivity activity) {
        super(activity.getPartnerTrack());
        this.fParentActivity = activity;
    }

    public void initialize(ReceiveDataSpecification spec) {
        this.fReceiveSpec = spec;
        this.fStatus = ArtefactStatus.createInitialStatus();
    }

    @Override
    public void run(ActivityContext context) {
        IncomingMessage incoming;
        try {
            incoming = context.receiveMessage(this.getPartnerTrack());
        }
        catch (TimeoutException e) {
            this.fStatus = ArtefactStatus.createErrorStatus("Timeout while waiting for incoming asynchronous message", e);
            return;
        }
        catch (InterruptedException e) {
            this.fStatus = ArtefactStatus.createAbortedStatus("Aborted while waiting for incoming asynchronous messsage", e);
            return;
        }
        this.fReceiveSpec.handle(context, incoming.getBody());
        try {
            OutgoingMessage outgoing = new OutgoingMessage();
            outgoing.setCode(202);
            outgoing.setBody("");
            context.postAnswer(this.getPartnerTrack(), outgoing);
            this.fStatus = this.fReceiveSpec.hasProblems() ? this.fReceiveSpec.getStatus() : ArtefactStatus.createPassedStatus();
        }
        catch (TimeoutException e) {
            this.fStatus = ArtefactStatus.createErrorStatus("Timeout occurred while waiting for ACK for asynchronous receive.", e);
        }
        catch (InterruptedException e) {
            this.fStatus = ArtefactStatus.createAbortedStatus("Aborted while waiting for ACK for asynchronous receive to be sent.", e);
        }
    }

    @Override
    public String getActivityCode() {
        return "ReceiveAsync";
    }

    @Override
    public int getActivityCount() {
        return 1;
    }

    @Override
    public String getName() {
        return "Receive Asynchronous";
    }

    @Override
    public ITestArtefact getParent() {
        if (this.fParentActivity != null) {
            return this.fParentActivity;
        }
        return this.getPartnerTrack();
    }

    @Override
    public List<ITestArtefact> getChildren() {
        ArrayList<ITestArtefact> children = new ArrayList<ITestArtefact>();
        children.add(this.fReceiveSpec);
        return children;
    }
}

