/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.model.test;

import com.rits.cloning.Cloner;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import net.bpelunit.framework.control.run.TestCaseRunner;
import net.bpelunit.framework.model.Partner;
import net.bpelunit.framework.model.test.TestCase;
import net.bpelunit.framework.model.test.activity.Activity;
import net.bpelunit.framework.model.test.activity.ActivityContext;
import net.bpelunit.framework.model.test.data.ContextXPathVariableResolver;
import net.bpelunit.framework.model.test.report.ArtefactStatus;
import net.bpelunit.framework.model.test.report.ITestArtefact;
import net.bpelunit.framework.model.test.report.StateData;
import org.apache.log4j.Logger;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.w3c.dom.Document;

public class PartnerTrack
implements ITestArtefact,
Runnable {
    private TestCase fTestCase;
    private List<Activity> fActivities;
    private Partner fPartner;
    private TestCaseRunner fRunner;
    private ArtefactStatus fStatus;
    private Logger fLogger;
    private String fAssumption;
    private NamespaceContext fNamespaceContext;
    private VelocityContext fTestCaseVelocityContext;
    private ActivityContext fActivityContext;
    private static final Cloner fCloner = new Cloner();

    public PartnerTrack(TestCase testCase, Partner client) {
        this.fPartner = client;
        this.fTestCase = testCase;
        this.fStatus = ArtefactStatus.createInitialStatus();
        this.fLogger = Logger.getLogger(this.getClass());
    }

    public void initialize(TestCaseRunner runner) {
        this.fRunner = runner;
    }

    public void setActivities(List<Activity> activities) {
        this.fActivities = activities;
    }

    @Override
    public void run() {
        this.fLogger.info((Object)(this.getName() + " now active."));
        this.fActivityContext = new ActivityContext(this.fRunner, this);
        if (this.assumptionHolds(this.fAssumption)) {
            for (Activity activity : this.fActivities) {
                if (this.assumptionHolds(activity.getAssumption())) {
                    this.fLogger.info((Object)(this.getName() + " now starting activity " + activity));
                    activity.run(this.fActivityContext);
                    this.fLogger.info((Object)(this.getName() + " returned from activity " + activity));
                } else {
                    this.fLogger.info((Object)(this.getName() + " skipped activity " + activity));
                }
                this.reportProgress(activity);
                if (!activity.hasProblems()) continue;
                this.fStatus = activity.getStatus();
                break;
            }
        } else {
            this.fLogger.info((Object)(this.getName() + " was skipped."));
        }
        if (!this.hasProblems()) {
            this.fStatus = ArtefactStatus.createPassedStatus();
        }
        this.fLogger.info((Object)(this.getName() + " finished."));
        this.reportProgress(this);
        if (this.hasProblems()) {
            this.fRunner.doneWithFault(this);
        } else {
            this.fRunner.done(this);
        }
    }

    public boolean hasProblems() {
        return this.fStatus.hasProblems();
    }

    public String getPartnerName() {
        return this.fPartner.getName();
    }

    public Partner getPartner() {
        return this.fPartner;
    }

    public int getActivityCount() {
        int activityCount = 0;
        for (Activity activity : this.fActivities) {
            activityCount += activity.getActivityCount();
        }
        return activityCount;
    }

    public String toString() {
        return this.getName();
    }

    public void setAssumption(String assumption) {
        this.fAssumption = assumption;
    }

    public void setNamespaceContext(NamespaceContext context) {
        this.fNamespaceContext = context;
    }

    @Override
    public String getName() {
        return "Partner Track " + this.getPartner().getName();
    }

    public String getRawName() {
        return this.getPartner().getName();
    }

    @Override
    public List<ITestArtefact> getChildren() {
        ArrayList<ITestArtefact> children = new ArrayList<ITestArtefact>();
        for (Activity activity : this.fActivities) {
            children.add(activity);
        }
        return children;
    }

    @Override
    public ITestArtefact getParent() {
        return this.fTestCase;
    }

    @Override
    public ArtefactStatus getStatus() {
        return this.fStatus;
    }

    @Override
    public List<StateData> getStateData() {
        return this.fStatus.getAsStateData();
    }

    @Override
    public void reportProgress(ITestArtefact artefac) {
        this.fTestCase.reportProgress(artefac);
    }

    public VelocityContext createVelocityContext() throws Exception {
        if (this.fTestCaseVelocityContext == null) {
            this.fTestCaseVelocityContext = this.fRunner.createVelocityContext();
        }
        VelocityContext ctx = (VelocityContext)fCloner.deepClone((Object)this.fTestCaseVelocityContext);
        ctx.put("partnerTrackName", (Object)this.getRawName());
        ctx.put("partnerTrackURL", (Object)this.getPartner().getSimulatedURL());
        if (this.fActivityContext != null) {
            ctx.put("request", (Object)this.fActivityContext.getLastRequest());
            ctx.put("partnerTrackReceived", this.fActivityContext.getReceivedMessages());
            ctx.put("partnerTrackSent", this.fActivityContext.getSentMessages());
        }
        return ctx;
    }

    private boolean assumptionHolds(String assumption) {
        if (assumption == null) {
            return true;
        }
        try {
            VelocityContext context = this.createVelocityContext();
            XPath xpath = XPathFactory.newInstance().newXPath();
            xpath.setNamespaceContext(this.fNamespaceContext);
            xpath.setXPathVariableResolver(new ContextXPathVariableResolver((Context)context));
            return (Boolean)xpath.evaluate(assumption, this.createEmptyDocument(), XPathConstants.BOOLEAN);
        }
        catch (Exception e) {
            this.fStatus = ArtefactStatus.createErrorStatus("Failed to evaluate the assumption " + this.fAssumption, e);
            return false;
        }
    }

    private Document createEmptyDocument() throws ParserConfigurationException {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
    }
}

