/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.coverage.annotation.tools.bpelxmltools.deploy.archivetools.impl;

import de.schlichtherle.io.ArchiveException;
import de.schlichtherle.io.FileInputStream;
import de.schlichtherle.io.FileOutputStream;
import de.schlichtherle.io.FileWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.bpelunit.framework.coverage.CoverageConstants;
import net.bpelunit.framework.coverage.annotation.tools.bpelxmltools.deploy.archivetools.IDeploymentArchiveHandler;
import net.bpelunit.framework.coverage.exceptions.ArchiveFileException;
import net.bpelunit.framework.coverage.exceptions.BpelException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class ActiveBPELDeploymentArchiveHandler
implements IDeploymentArchiveHandler {
    private static final String WSDL_DIRECTORY_IN_ARCHIVE = "wsdl/";
    private static final String WSDLENTRY_ELEMENT = "wsdlEntry";
    private static final String LOCATION_ATTR = "location";
    private static final String CLASSPATH_ATTR = "classpath";
    private static final String WSDL_ELEMENT = "wsdl";
    private static final String LOCATION_OF_WSDL_ATTR = "location";
    private static final String NAMESPACE_ATTR = "namespace";
    private static final String PORTNAME_ATTR = "PortName";
    private static final String ENDPOINT_REFERENCE_ATTR = "endpointReference";
    private static final String ENDPOINT_REFERENCE_ATTR_VALUE = "static";
    private static final String NAME_ATTR = "name";
    private static final String SERVICENAME_ELEMENT = "ServiceName";
    private static String WSDL_FILE_IN_ARCHIVE;
    private Hashtable<String, de.schlichtherle.io.File> bpelFiles;
    private de.schlichtherle.io.File archiveFile;
    private Logger fLogger = Logger.getLogger(this.getClass());

    public ActiveBPELDeploymentArchiveHandler() {
        this.bpelFiles = new Hashtable();
    }

    @Override
    public String createArchivecopy(String archive) throws ArchiveFileException {
        de.schlichtherle.io.File copyFile = this.archiveFile = this.createCopy(archive);
        this.searchBPELFiles();
        return copyFile.getName();
    }

    private de.schlichtherle.io.File createCopy(String archive) throws ArchiveFileException {
        String fileName = FilenameUtils.getName((String)archive);
        String pfad = FilenameUtils.getFullPath((String)archive);
        String nameOfCopy = '_' + fileName;
        de.schlichtherle.io.File copyFile = new de.schlichtherle.io.File(FilenameUtils.concat((String)pfad, (String)nameOfCopy));
        de.schlichtherle.io.File file = new de.schlichtherle.io.File(archive);
        copyFile.copyAllFrom((File)file);
        try {
            de.schlichtherle.io.File.umount((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
        catch (ArchiveException e) {
            throw new ArchiveFileException("Could not create copy of bpr-archive", e);
        }
        this.fLogger.info((Object)("CoverageTool:Copy of BPR-archive " + nameOfCopy + " is created."));
        return copyFile;
    }

    public de.schlichtherle.io.File getBPELFile(int i) {
        de.schlichtherle.io.File bpelFile = this.bpelFiles.get(i);
        return bpelFile;
    }

    private void searchBPELFiles() {
        this.fLogger.info((Object)"CoverageTool:Search for BPEL-files is started");
        de.schlichtherle.io.File file = new de.schlichtherle.io.File(this.archiveFile.getPath());
        this.searchChildrenBPEL(file);
    }

    private void searchChildrenBPEL(de.schlichtherle.io.File file) {
        File[] files = file.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                this.searchChildrenBPEL((de.schlichtherle.io.File)files[i]);
            }
        } else if (FilenameUtils.getExtension((String)file.getName()).equals("bpel")) {
            this.bpelFiles.put(file.getInnerEntryName(), file);
        }
    }

    @Override
    public void addWSDLFile(File wsdlFile) throws ArchiveFileException {
        WSDL_FILE_IN_ARCHIVE = WSDL_DIRECTORY_IN_ARCHIVE + wsdlFile.getName();
        this.fLogger.info((Object)("CoverageTool: Adding WSDL-file " + wsdlFile.getPath() + " for CoverageLogging in bpr-archive"));
        FileOutputStream out = null;
        try {
            this.adaptWsdlCatalog();
            out = new FileOutputStream(this.archiveFile.getPath() + "/" + WSDL_FILE_IN_ARCHIVE);
            out.write(FileUtils.readFileToByteArray((File)wsdlFile));
            this.fLogger.info((Object)"CoverageTool: WSDL-file sucessfull added.");
        }
        catch (IOException e) {
            throw new ArchiveFileException("Could not add WSDL file for coverage measurement tool (" + wsdlFile.getName() + ") in deployment archive ", e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.prepareDeploymentDescriptor();
    }

    private void adaptWsdlCatalog() throws ArchiveFileException {
        FileInputStream is = null;
        FileWriter writer = null;
        de.schlichtherle.io.File file = this.getWSDLCatalog();
        Document doc = null;
        try {
            is = new FileInputStream((File)file);
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build((InputStream)is);
            Element wsdlCatalog = doc.getRootElement();
            Element wsdlEntry = new Element(WSDLENTRY_ELEMENT, wsdlCatalog.getNamespace());
            wsdlEntry.setAttribute("location", WSDL_FILE_IN_ARCHIVE);
            wsdlEntry.setAttribute(CLASSPATH_ATTR, WSDL_FILE_IN_ARCHIVE);
            wsdlCatalog.addContent((Content)wsdlEntry);
        }
        catch (JDOMException e) {
            throw new ArchiveFileException("An XML reading error occurred when reading the WSDL catalog.", e);
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
            throw new ArchiveFileException("An I/O error occurred when reading the WSDL catalog.", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        try {
            writer = new FileWriter(file);
            XMLOutputter xmlOutputter = new XMLOutputter(Format.getPrettyFormat());
            xmlOutputter.output(doc, (Writer)writer);
        }
        catch (IOException e) {
            throw new ArchiveFileException("An I/O error occurred when writing the WSDL catalog.", e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private de.schlichtherle.io.File getWSDLCatalog() {
        String pfad = FilenameUtils.concat((String)FilenameUtils.concat((String)this.archiveFile.getPath(), (String)"META-INF"), (String)"wsdlCatalog.xml");
        de.schlichtherle.io.File wsdlCatalog = new de.schlichtherle.io.File(pfad);
        return wsdlCatalog;
    }

    private void prepareDeploymentDescriptor() throws ArchiveFileException {
        FileInputStream is = null;
        FileWriter writer = null;
        List<String> pddFiles = this.getDeploymentDescriptors();
        Iterator<String> iter = pddFiles.iterator();
        while (iter.hasNext()) {
            de.schlichtherle.io.File descriptor = new de.schlichtherle.io.File(this.archiveFile.getPath() + "/" + iter.next());
            try {
                SAXBuilder builder = new SAXBuilder();
                is = new FileInputStream((File)descriptor);
                Document doc = builder.build((InputStream)is);
                Element process = doc.getRootElement();
                this.addPartnerLinkEndpoint(process);
                this.addWSDLEntry(process);
                writer = new FileWriter(descriptor);
                XMLOutputter xmlOutputter = new XMLOutputter(Format.getPrettyFormat());
                xmlOutputter.output(doc, (Writer)writer);
            }
            catch (IOException e) {
                throw new ArchiveFileException("An I/O error occurred when writing deployment descriptor: " + descriptor.getName(), e);
            }
            catch (JDOMException e) {
                throw new ArchiveFileException("An XML reading error occurred when reading the deployment descriptor: " + descriptor.getName(), e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
                if (writer == null) continue;
                try {
                    writer.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void addWSDLEntry(Element process) {
        Element wsdl = new Element(WSDL_ELEMENT, process.getNamespace());
        wsdl.setAttribute("location", WSDL_FILE_IN_ARCHIVE);
        wsdl.setAttribute(NAMESPACE_ATTR, CoverageConstants.COVERAGETOOL_NAMESPACE.getURI());
        Element references = this.getReferencesElement(process);
        references.addContent((Content)wsdl);
        this.fLogger.info((Object)"CoverageTool:Reference of _LogService.wsdl in BPEL added.");
    }

    private Element getReferencesElement(Element process) {
        Element references = null;
        references = process.getChild("references", process.getNamespace());
        if (references == null) {
            references = process.getChild("wsdlReferences", process.getNamespace());
        }
        if (references == null) {
            references = new Element("references", process.getNamespace());
            process.addContent((Content)references);
        }
        return references;
    }

    private List<String> getDeploymentDescriptors() throws ArchiveFileException {
        String[] content = this.archiveFile.list();
        ArrayList<String> pddFiles = new ArrayList<String>();
        String name = null;
        for (int i = 0; i < content.length; ++i) {
            name = content[i];
            if (!FilenameUtils.getExtension((String)name).equals("pdd")) continue;
            pddFiles.add(name);
        }
        if (pddFiles.size() == 0) {
            throw new ArchiveFileException("Process deployment descriptor in bpr-archive not found");
        }
        this.fLogger.info((Object)("CoverageTool: gefunden " + name + " pdd-Datei"));
        return pddFiles;
    }

    private void addPartnerLinkEndpoint(Element process) {
        Namespace ns = Namespace.getNamespace((String)"wsa", (String)"http://schemas.xmlsoap.org/ws/2003/03/addressing");
        process.addNamespaceDeclaration(ns);
        Element adress = new Element("Address", ns);
        adress.setText(CoverageConstants.ADDRESS_OF_SERVICE);
        Element serviceName = new Element(SERVICENAME_ELEMENT, ns);
        serviceName.setAttribute(PORTNAME_ATTR, "Soap_service_port");
        serviceName.setText(CoverageConstants.COVERAGETOOL_NAMESPACE.getPrefix() + ":" + "_CoverageReportingService_");
        Element endpointReference = new Element("EndpointReference", ns);
        endpointReference.addNamespaceDeclaration(CoverageConstants.COVERAGETOOL_NAMESPACE);
        endpointReference.addContent((Content)adress);
        endpointReference.addContent((Content)serviceName);
        Element partnerRole = new Element("partnerRole", process.getNamespace());
        partnerRole.setAttribute(ENDPOINT_REFERENCE_ATTR, ENDPOINT_REFERENCE_ATTR_VALUE);
        partnerRole.addContent((Content)endpointReference);
        Element partnerLink = new Element("partnerLink", process.getNamespace());
        partnerLink.setAttribute(NAME_ATTR, "PL_CoverageReportingService_");
        partnerLink.addContent((Content)partnerRole);
        Element partnerLinks = process.getChild("partnerLinks", process.getNamespace());
        if (partnerLinks == null) {
            partnerLinks = new Element("partnerLinks", process.getNamespace());
            process.addContent((Content)partnerLinks);
        }
        partnerLinks.addContent((Content)partnerLink);
        this.fLogger.info((Object)"CoverageTool:PartnerLink for Covergae_Logging_Service in BPEL added.");
    }

    @Override
    public Document getDocument(String bpelFile) throws BpelException {
        de.schlichtherle.io.File file = this.bpelFiles.get(bpelFile);
        return this.readBPELDocument(file);
    }

    @Override
    public void writeDocument(Document doc, String fileName) throws ArchiveFileException {
        this.writeBPELDocument(this.bpelFiles.get(fileName), doc);
    }

    private Document readBPELDocument(de.schlichtherle.io.File file) throws BpelException {
        FileInputStream is = null;
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        try {
            is = new FileInputStream((File)file);
            doc = builder.build((InputStream)is);
        }
        catch (IOException e) {
            throw new BpelException("An I/O error occurred when reading the BPEL file: " + file.getName(), e);
        }
        catch (JDOMException e) {
            throw new BpelException("An XML reading error occurred reading the BPEL file " + file.getName(), e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return doc;
    }

    private void writeBPELDocument(de.schlichtherle.io.File file, Document doc) throws ArchiveFileException {
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            XMLOutputter xmlOutputter = new XMLOutputter(Format.getPrettyFormat());
            xmlOutputter.output(doc, (Writer)writer);
        }
        catch (IOException e) {
            throw new ArchiveFileException("An I/O error occurred when writing the BPEL file: " + file.getName(), e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public Set<String> getAllBPELFileNames() {
        return this.bpelFiles.keySet();
    }

    @Override
    public void closeArchive() {
        try {
            de.schlichtherle.io.File.umount((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
        catch (ArchiveException archiveException) {
            // empty catch block
        }
    }
}

