/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.control.soap;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.Text;
import net.bpelunit.framework.control.ext.ISOAPEncoder;
import net.bpelunit.framework.control.util.BPELUnitUtil;
import net.bpelunit.framework.exception.SOAPEncodingException;
import net.bpelunit.framework.model.test.data.SOAPOperationCallIdentifier;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocumentLiteralEncoder
implements ISOAPEncoder {
    @Override
    public SOAPMessage construct(SOAPOperationCallIdentifier operation, Element literalElement, QName faultCode, String faultString) throws SOAPEncodingException {
        try {
            SOAPBody data;
            MessageFactory mFactory = BPELUnitUtil.getMessageFactoryInstance();
            SOAPFactory sFactory = SOAPFactory.newInstance();
            SOAPMessage message = mFactory.createMessage();
            SOAPBody body = message.getSOAPBody();
            if (operation.isFault()) {
                SOAPFault fault = body.addFault(faultCode, faultString);
                data = fault.addDetail();
            } else {
                data = body;
            }
            NodeList nodes = literalElement.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                SOAPElement soapElement = sFactory.createElement((Element)nodes.item(i));
                data.addChildElement(soapElement);
            }
            return message;
        }
        catch (SOAPException e) {
            throw new SOAPEncodingException("A SOAPException occurred in the DocumentLiteralEncoder while encoding to operation " + operation, e);
        }
    }

    @Override
    public Element deconstruct(SOAPOperationCallIdentifier operation, SOAPMessage message) throws SOAPEncodingException {
        try {
            SOAPBody data = message.getSOAPBody();
            Element rawRoot = BPELUnitUtil.generateDummyElementNode();
            Iterator i = data.getChildElements();
            while (i.hasNext()) {
                SOAPElement element;
                Object current = i.next();
                if (current instanceof SOAPElement) {
                    element = (SOAPElement)current;
                    rawRoot.appendChild(rawRoot.getOwnerDocument().importNode((Node)element, true));
                }
                if (!(current instanceof Text)) continue;
                element = (Text)current;
                rawRoot.appendChild(rawRoot.getOwnerDocument().importNode((Node)element, true));
            }
            return rawRoot;
        }
        catch (SOAPException e) {
            throw new SOAPEncodingException("A SOAPException occurred in the DocumentLiteralEncoder while decoding for operation " + operation);
        }
    }
}

