/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.control.run;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import net.bpelunit.framework.BPELUnitRunner;
import net.bpelunit.framework.control.run.BlackBoard;
import net.bpelunit.framework.control.ws.LocalHTTPServer;
import net.bpelunit.framework.exception.PartnerNotFoundException;
import net.bpelunit.framework.exception.SynchronousSendException;
import net.bpelunit.framework.model.test.PartnerTrack;
import net.bpelunit.framework.model.test.TestCase;
import net.bpelunit.framework.model.test.wire.IncomingMessage;
import net.bpelunit.framework.model.test.wire.OutgoingMessage;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.log4j.Logger;
import org.apache.velocity.VelocityContext;

public class TestCaseRunner {
    public static int wait_time_for_coverage_markers = 500;
    private TestCase fTestCase;
    private Map<PartnerTrack, PartnerTrackResult> fPartnerTracks;
    private boolean fProblemOccurred;
    private BlackBoard<PartnerTrack, IncomingMessage> fIncomingBlackboard;
    private BlackBoard<PartnerTrack, OutgoingMessage> fOutgoingBlackboard;
    private BlackBoard<OutgoingMessage, Boolean> fSentBlackBoard;
    private LocalHTTPServer fServer;
    private static final MultiThreadedHttpConnectionManager fConnectionManager = new MultiThreadedHttpConnectionManager();
    private HttpClient fClient;
    private Logger fLogger;
    private boolean fAbortedByUser;
    private TestCaseRunner instance = this;
    private boolean allMarkersReceived;

    public TestCaseRunner(LocalHTTPServer localServer, TestCase caseToRun) {
        this.fTestCase = caseToRun;
        this.fServer = localServer;
        this.fProblemOccurred = false;
        this.fAbortedByUser = false;
        this.fClient = new HttpClient((HttpConnectionManager)fConnectionManager);
        List<PartnerTrack> partnerTracks = caseToRun.getPartnerTracks();
        for (PartnerTrack partnerTrack : partnerTracks) {
            partnerTrack.initialize(this);
        }
        this.fPartnerTracks = new HashMap<PartnerTrack, PartnerTrackResult>();
        for (PartnerTrack head : partnerTracks) {
            this.fPartnerTracks.put(head, PartnerTrackResult.RUNNING);
        }
        this.fIncomingBlackboard = new BlackBoard();
        this.fOutgoingBlackboard = new BlackBoard();
        this.fSentBlackBoard = new BlackBoard();
        this.fLogger = Logger.getLogger(this.getClass());
    }

    public void run() {
        this.fLogger.info((Object)("Initiating testCase " + this.fTestCase.getName()));
        this.fServer.startTest(this);
        ArrayList<Thread> threads = new ArrayList<Thread>();
        boolean measureTestcoverage = BPELUnitRunner.measureTestCoverage();
        if (measureTestcoverage) {
            BPELUnitRunner.getCoverageMeasurmentTool().setCurrentTestCase(this.fTestCase.getName());
        }
        for (PartnerTrack partnerTrack : this.fPartnerTracks.keySet()) {
            Thread trackThread = new Thread((Runnable)partnerTrack, partnerTrack.getPartnerName());
            this.fLogger.debug((Object)("Now starting thread for partner " + partnerTrack.getPartnerName()));
            trackThread.start();
            threads.add(trackThread);
        }
        this.fLogger.info((Object)"TestCase was started.");
        this.waitForPartnerTracksOrError();
        if (measureTestcoverage) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        1.sleep(wait_time_for_coverage_markers);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    TestCaseRunner.this.instance.setAllMarkersReceived(true);
                }
            };
            this.allMarkersReceived = false;
            thread.start();
            this.waitForAllCoverageMarkers();
        }
        if (this.fProblemOccurred || this.fAbortedByUser) {
            for (PartnerTrack partnerTrack : this.fPartnerTracks.keySet()) {
                if (!partnerTrack.getStatus().isError() && !partnerTrack.getStatus().isFailure()) continue;
                this.fLogger.info((Object)String.format("A test failure or error occurred on %s: %s", partnerTrack.getName(), partnerTrack.getStatus().getMessage()));
            }
            this.fLogger.debug((Object)"Trying to interrupt all threads...");
            for (Thread t : threads) {
                if (!t.isAlive()) continue;
                t.interrupt();
            }
            this.fLogger.debug((Object)"All threads interrupted. Waiting for threads...");
            this.waitForPartnerTracks();
        } else {
            this.fLogger.info((Object)"Test case passed.");
        }
        this.fLogger.debug((Object)"All threads returned.");
        this.fServer.stopTest(this);
        this.fLogger.info((Object)("Stopping testCase " + this.fTestCase.getName()));
    }

    private synchronized void waitForAllCoverageMarkers() {
        this.fLogger.info((Object)"TestcaseRunner is waiting for coverage markers!");
        while (!this.allMarkersReceived) {
            try {
                this.wait(150L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.fLogger.info((Object)"TestcaseRunner all coverage markers received!");
    }

    protected void setAllMarkersReceived(boolean markersReceived) {
        this.allMarkersReceived = markersReceived;
    }

    public synchronized PartnerTrack findPartnerTrackForName(String name) throws PartnerNotFoundException {
        for (PartnerTrack partnerTrack : this.fPartnerTracks.keySet()) {
            if (!partnerTrack.getPartnerName().equalsIgnoreCase(name)) continue;
            if (partnerTrack.getActivityCount() != 0) {
                return partnerTrack;
            }
            throw new PartnerNotFoundException("Partner found, but zero activities for name " + name);
        }
        throw new PartnerNotFoundException("No partner found for name " + name);
    }

    public IncomingMessage receiveMessage(PartnerTrack partnerTrack) throws TimeoutException, InterruptedException {
        return this.fIncomingBlackboard.getObject(partnerTrack);
    }

    public void sendBackMessage(PartnerTrack partnerTrack, OutgoingMessage message) throws TimeoutException, InterruptedException {
        this.fOutgoingBlackboard.putObject(partnerTrack, message);
        this.fSentBlackBoard.getObject(message);
    }

    public IncomingMessage sendMessageSynchronous(OutgoingMessage message) throws SynchronousSendException, InterruptedException {
        StringRequestEntity entity;
        PostMethod method = new PostMethod(message.getTargetURL());
        method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(1, false));
        method.getParams().setParameter("http.socket.timeout", (Object)new Integer(BPELUnitRunner.getTimeout()));
        method.addRequestHeader("SOAPAction", "\"" + message.getSOAPHTTPAction() + "\"");
        try {
            entity = new StringRequestEntity(message.getBody(), "text/xml", "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new SynchronousSendException("Unsupported encoding when trying to post message to web service.", e);
        }
        method.setRequestEntity((RequestEntity)entity);
        try {
            int statusCode = this.fClient.executeMethod((HttpMethod)method);
            String responseBody = method.getResponseBodyAsString();
            IncomingMessage returnMsg = new IncomingMessage();
            returnMsg.setStatusCode(statusCode);
            returnMsg.setBody(responseBody);
            IncomingMessage incomingMessage = returnMsg;
            return incomingMessage;
        }
        catch (Exception e) {
            if (this.isAborting()) {
                throw new InterruptedException();
            }
            throw new SynchronousSendException(e);
        }
        finally {
            method.releaseConnection();
        }
    }

    public synchronized void done(PartnerTrack track) {
        this.fPartnerTracks.put(track, PartnerTrackResult.COMPLETED);
        this.notifyAll();
    }

    public synchronized void doneWithFault(PartnerTrack track) {
        this.fProblemOccurred = true;
        this.fPartnerTracks.put(track, PartnerTrackResult.COMPLETED);
        this.notifyAll();
    }

    public OutgoingMessage getWSOutgoingMessage(PartnerTrack head) throws TimeoutException, InterruptedException {
        return this.fOutgoingBlackboard.getObject(head);
    }

    public void putWSIncomingMessage(PartnerTrack head, IncomingMessage message) throws InterruptedException {
        this.fIncomingBlackboard.putObject(head, message);
    }

    public void putWSOutgoingMessageSent(OutgoingMessage message) throws InterruptedException {
        this.fSentBlackBoard.putObject(message, true);
    }

    private synchronized void waitForPartnerTracksOrError() {
        while (!(this.allPartnerTracksCompleted() || this.fProblemOccurred || this.fAbortedByUser)) {
            try {
                this.wait(150L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized void waitForPartnerTracks() {
        while (!this.allPartnerTracksCompleted()) {
            try {
                this.wait(150L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized boolean allPartnerTracksCompleted() {
        for (PartnerTrack head : this.fPartnerTracks.keySet()) {
            if (!this.fPartnerTracks.get(head).equals((Object)PartnerTrackResult.RUNNING)) continue;
            return false;
        }
        return true;
    }

    private boolean isAborting() {
        return this.fProblemOccurred || this.fAbortedByUser;
    }

    public void abortTest() {
        this.fAbortedByUser = true;
    }

    public VelocityContext createVelocityContext() throws Exception {
        return this.fTestCase.createVelocityContext();
    }

    private static enum PartnerTrackResult {
        RUNNING,
        COMPLETED;

    }
}

