/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.control.datasource;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.bpelunit.framework.control.ext.IDataSource;
import net.bpelunit.framework.exception.DataSourceException;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

@IDataSource.DataSource(name="Velocity Data Source", shortName="velocity", contentTypes={})
public class VelocityDataSource
implements IDataSource {
    static final String PROPERTY_ITERATED_VARS = "iteratedVars";
    private List<String> fIteratedVars;
    private VelocityContext fContext;
    private int fRowCount;
    private int fCurrentRow = -1;

    @Override
    public int getNumberOfRows() {
        return this.fRowCount;
    }

    @Override
    public void setRow(int index) throws DataSourceException {
        if (index >= this.fRowCount) {
            throw new DataSourceException(String.format("Index %d is out of bounds [0, %d]", index, this.fRowCount - 1));
        }
        this.fCurrentRow = index;
    }

    @Override
    public String[] getFieldNames() {
        Object[] objKeys = this.fContext.getKeys();
        String[] keys = new String[objKeys.length];
        for (int i = 0; i < objKeys.length; ++i) {
            keys[i] = objKeys[i].toString();
        }
        return keys;
    }

    @Override
    public Object getValueFor(String fieldName) {
        if (this.fIteratedVars.contains(fieldName)) {
            return ((List)this.fContext.get(fieldName)).get(this.fCurrentRow);
        }
        return this.fContext.get(fieldName);
    }

    @Override
    public void close() {
        this.fContext = null;
    }

    @Override
    public void loadFromStream(InputStream is) throws DataSourceException {
        try {
            Velocity.init();
        }
        catch (Exception e) {
            throw new DataSourceException("Error while initializing Velocity", e);
        }
        String script = this.readContentsAsString(is);
        this.fContext = new VelocityContext();
        try {
            StringWriter sW = new StringWriter();
            Velocity.evaluate((Context)this.fContext, (Writer)sW, (String)"datasource", (String)script);
        }
        catch (Exception e) {
            throw new DataSourceException("Error while evaluating the Velocity template:\n" + script, e);
        }
        this.validateIteratedVars();
    }

    @IDataSource.ConfigurationOption(description="The names of the variables that should be used as test data. The list is space separated.", defaultValue="")
    public void setIteratedVars(String value) throws DataSourceException {
        StringTokenizer tok = new StringTokenizer(value);
        ArrayList<String> iterVars = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            iterVars.add(tok.nextToken());
        }
        if (iterVars.isEmpty()) {
            throw new DataSourceException("Iterated variable list cannot be empty");
        }
        this.fIteratedVars = iterVars;
    }

    private String readContentsAsString(InputStream is) throws DataSourceException {
        String script;
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            StringBuffer sbuf = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                sbuf.append(line);
                sbuf.append('\n');
            }
            script = sbuf.toString();
        }
        catch (Exception e) {
            throw new DataSourceException("Error while reading the Velocity script", e);
        }
        return script;
    }

    private void validateIteratedVars() throws DataSourceException {
        if (this.fIteratedVars == null) {
            throw new DataSourceException("iteratedVars property is required.");
        }
        if (this.fIteratedVars.isEmpty()) {
            throw new DataSourceException("iteratedVars must refer to at least one variable.");
        }
        this.fRowCount = -1;
        for (String var : this.fIteratedVars) {
            Object value = this.fContext.get(var);
            if (value == null) {
                throw new DataSourceException("Iterated variable " + var + " is not set in the Velocity script of " + "this data source.");
            }
            if (!(value instanceof List)) {
                throw new DataSourceException("Iterated variable " + var + " does not contain a list literal.");
            }
            List arrList = (List)value;
            if (this.fRowCount != -1) {
                if (arrList.size() == this.fRowCount) continue;
                throw new DataSourceException("Iterated variable " + var + " has mismatching length: should have " + this.fRowCount + " element" + (this.fRowCount > 1 ? "s" : ""));
            }
            if (arrList.size() == 0) {
                throw new DataSourceException("Iterated variable " + var + " should have at least one element");
            }
            this.fRowCount = arrList.size();
        }
    }
}

