/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.wizards;

import net.bpelunit.framework.control.util.BPELUnitUtil;
import net.bpelunit.framework.xml.suite.XMLDeploymentSection;
import net.bpelunit.framework.xml.suite.XMLTestSuite;
import net.bpelunit.framework.xml.suite.XMLTestSuiteDocument;
import net.bpelunit.toolsupport.ToolSupportActivator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class BPELUnitNewWizard
extends BasicNewResourceWizard {
    private WizardNewFileCreationPage mainPage;

    public void addPages() {
        super.addPages();
        this.mainPage = new WizardNewFileCreationPage("newBPTSPage", this.getSelection());
        this.mainPage.setTitle("New BPELUnit Test Suite");
        this.mainPage.setDescription("Creates a new BPELUnit Test Suite (.bpts)");
        this.mainPage.setFileName("suite.bpts");
        this.addPage((IWizardPage)this.mainPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setWindowTitle("New TestSuite");
        this.setNeedsProgressMonitor(true);
    }

    protected void initializeDefaultPageImageDescriptor() {
        this.setDefaultPageImageDescriptor(ToolSupportActivator.getImageDescriptor("icons/new_wiz.png"));
    }

    public boolean performFinish() {
        IFile file;
        String fileName = this.mainPage.getFileName();
        if (!fileName.endsWith(".bpts")) {
            fileName = String.valueOf(fileName) + ".bpts";
            this.mainPage.setFileName(fileName);
        }
        if ((file = this.mainPage.createNewFile()) == null) {
            return false;
        }
        XMLTestSuiteDocument document = null;
        try {
            document = XMLTestSuiteDocument.Factory.newInstance();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        XMLTestSuite suite = document.addNewTestSuite();
        XMLDeploymentSection deploymentSection = suite.addNewDeployment();
        deploymentSection.addNewPut();
        suite.addNewTestCases();
        suite.setName(file.getName());
        IWorkbenchWindow dw = this.getWorkbench().getActiveWorkbenchWindow();
        try {
            file.setContents(document.newInputStream(BPELUnitUtil.getDefaultXMLOptions()), 0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error writing initial data", (String)"Could not create the .bpts file");
        }
        this.selectAndReveal((IResource)file);
        try {
            IWorkbenchPage page;
            if (dw != null && (page = dw.getActivePage()) != null) {
                IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
            }
        }
        catch (PartInitException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Problems Opening Editor", (String)e.getMessage());
            ToolSupportActivator.log(e);
        }
        return true;
    }
}

