/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.util.schema;

import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSAttributeUse;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSModelGroup;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSTerm;
import com.sun.xml.xsom.XSType;
import com.sun.xml.xsom.parser.AnnotationParserFactory;
import com.sun.xml.xsom.parser.XSOMParser;
import com.sun.xml.xsom.util.DomAnnotationParserFactory;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.xml.namespace.QName;
import net.bpelunit.toolsupport.util.schema.ErrorAdapter;
import net.bpelunit.toolsupport.util.schema.SchemaElementManager;
import net.bpelunit.toolsupport.util.schema.impl.SchemaElementManagerImpl;
import net.bpelunit.toolsupport.util.schema.nodes.Attribute;
import net.bpelunit.toolsupport.util.schema.nodes.ComplexType;
import net.bpelunit.toolsupport.util.schema.nodes.Element;
import net.bpelunit.toolsupport.util.schema.nodes.SimpleType;
import net.bpelunit.toolsupport.util.schema.nodes.impl.AttributeImpl;
import net.bpelunit.toolsupport.util.schema.nodes.impl.ComplexTypeImpl;
import net.bpelunit.toolsupport.util.schema.nodes.impl.ElementImpl;
import net.bpelunit.toolsupport.util.schema.nodes.impl.SimpleTypeImpl;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class SchemaParser {
    private ErrorAdapter errorHandler = new ErrorAdapter();
    private SchemaElementManager elementManager = new SchemaElementManagerImpl();

    public void setErrorHandler(ErrorAdapter errorHandler) {
        if (errorHandler != null) {
            this.errorHandler = errorHandler;
        }
    }

    public HashMap<QName, Element> getElements() {
        return this.elementManager.getElements();
    }

    HashMap<QName, ComplexType> getComplexTypes() {
        return this.elementManager.getComplexTypes();
    }

    HashMap<QName, SimpleType> getSimpleTypes() {
        return this.elementManager.getSimpleTypes();
    }

    public void parse(File file) throws SAXException, IOException {
        XSOMParser reader = new XSOMParser();
        reader.setErrorHandler((ErrorHandler)this.errorHandler);
        reader.setAnnotationParser((AnnotationParserFactory)new DomAnnotationParserFactory());
        reader.parse(file);
        this.readSchemata(reader.getResult());
    }

    public void readSchemata(XSSchemaSet schemata) {
        for (XSSchema schema : schemata.getSchemas()) {
            this.readSchema(schema);
        }
    }

    private void readSchema(XSSchema schema) {
        if ("http://www.w3.org/2001/XMLSchema".equals(schema.getTargetNamespace())) {
            return;
        }
        for (XSElementDecl elementDecl : schema.getElementDecls().values()) {
            this.readElement(elementDecl, false);
        }
        for (XSSimpleType simpleType : schema.getSimpleTypes().values()) {
            this.readSimpleType(simpleType);
        }
        for (XSComplexType complexType : schema.getComplexTypes().values()) {
            this.readComplexType(complexType);
        }
    }

    private Element readElement(XSElementDecl decl, boolean isNested) {
        Element element;
        if (isNested) {
            element = new ElementImpl(decl.getTargetNamespace(), decl.getName());
            element.setNillable(decl.isNillable());
        } else {
            element = this.elementManager.getElement(decl.getTargetNamespace(), decl.getName());
        }
        XSType declType = decl.getType();
        if (declType instanceof XSSimpleType) {
            element.setType(this.readSimpleType((XSSimpleType)declType));
        }
        if (declType instanceof XSComplexType) {
            element.setType(this.readComplexType((XSComplexType)declType));
        }
        return element;
    }

    private ComplexType readComplexType(XSComplexType xsComplex) {
        ComplexType complex;
        String targetNamespace = xsComplex.getTargetNamespace();
        String name = xsComplex.getName();
        if (name == null) {
            complex = new ComplexTypeImpl(targetNamespace, name);
        } else {
            complex = this.elementManager.getComplexType(targetNamespace, name);
            if (!this.elementManager.wasLastComplexNewCreated()) {
                return complex;
            }
        }
        for (XSAttributeUse attributeUse : xsComplex.getAttributeUses()) {
            complex.addAttribute(this.readAttribute(targetNamespace, attributeUse.getDecl()));
        }
        if (xsComplex.getContentType().asParticle() != null) {
            XSModelGroup mainModelGroup = xsComplex.getContentType().asParticle().getTerm().asModelGroup();
            this.readModelGroup(complex, mainModelGroup);
        }
        return complex;
    }

    private void readModelGroup(ComplexType complex, XSModelGroup modelGroup) {
        XSParticle[] xSParticleArray = modelGroup.getChildren();
        int n = xSParticleArray.length;
        int n2 = 0;
        while (n2 < n) {
            XSParticle particle = xSParticleArray[n2];
            XSTerm term = particle.getTerm();
            XSElementDecl elemDecl = term.asElementDecl();
            if (elemDecl != null) {
                Element element = this.readElement(elemDecl, true);
                element.setMaxOccurs(particle.getMaxOccurs());
                element.setMinOccurs(particle.getMinOccurs());
                complex.addElement(element);
            } else {
                XSModelGroup nestedModelGroup = term.asModelGroup();
                if (nestedModelGroup != null) {
                    this.readModelGroup(complex, nestedModelGroup);
                }
            }
            ++n2;
        }
    }

    private Attribute readAttribute(String targetNamespace, XSAttributeDecl decl) {
        String attributeName = decl.getName();
        AttributeImpl attribute = new AttributeImpl(targetNamespace, attributeName);
        attribute.setType(this.readSimpleType(decl.getType()));
        if (decl.getFixedValue() != null) {
            attribute.setFixedValue(decl.getFixedValue().value);
        }
        if (decl.getDefaultValue() != null) {
            attribute.setDefaultValue(decl.getDefaultValue().value);
        }
        return attribute;
    }

    private SimpleType readSimpleType(XSSimpleType decl) {
        String localPart = decl.getName();
        if (localPart == null) {
            return new SimpleTypeImpl(decl.getTargetNamespace(), localPart);
        }
        return this.elementManager.getSimpleType(decl.getTargetNamespace(), decl.getName());
    }

    public SchemaElementManager getSchemaElementManager() {
        return this.elementManager;
    }
}

