/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.util.schema;

import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import net.bpelunit.toolsupport.util.schema.InvalidInputException;
import net.bpelunit.toolsupport.util.schema.NoElementDefinitionExistsException;
import net.bpelunit.toolsupport.util.schema.WSDLParser;
import net.bpelunit.toolsupport.util.schema.nodes.ComplexType;
import net.bpelunit.toolsupport.util.schema.nodes.Element;
import net.bpelunit.toolsupport.util.schema.nodes.SimpleType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RPCLiteralTest {
    private static final String WSDL_OPERATION_ONLYINPUT = "elemAttrInRpcLitOp";
    private static final String WSDL_IMPORT_NAMESPACE = "http://www.example.org/rpcLiteralTestImported/";
    private static final String WSDL_PATH = "testSchemata/rpcLiteralTest.wsdl";
    private static final String WSDL_TYPES_NAMESPACE = "http://www.example.org/rpcLiteralTest/Types";
    private static final String XSD_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    static final String WSDL_OPERATION = "doSomething";
    static final String WSDL_PORT = "rpcLiteralTestSOAP";
    static final String WSDL_SERVICE_NAME = "rpcLiteralTest";
    static final String WSDL_SERVICE_NAMESPACE = "http://www.example.org/rpcLiteralTest/";
    static final String WSDL_INPUT_NAMESPACE = "http://www.example.org/rpcLiteralTest/Input";
    static final QName WSDL_SERVICE_QNAME = new QName("http://www.example.org/rpcLiteralTest/", "rpcLiteralTest");
    private WSDLParser fParser;

    @Before
    public void setUp() throws Exception {
        WSDLFactory factory = WSDLFactory.newInstance();
        WSDLReader reader = factory.newWSDLReader();
        Definition definition = reader.readWSDL(null, WSDL_PATH);
        this.fParser = new WSDLParser(definition);
    }

    @Test
    public void generatedInputElementIsCorrect() throws Exception {
        Element wrapperElement = this.fParser.getInputElementForOperation(WSDL_SERVICE_QNAME, WSDL_PORT, WSDL_OPERATION);
        Assert.assertEquals((String)"main element should be the usual RPC wrapper", (Object)new QName(WSDL_INPUT_NAMESPACE, WSDL_OPERATION), (Object)wrapperElement.getQName());
        ComplexType wrapperType = wrapperElement.getType().getAsComplexType();
        Assert.assertNotNull((String)"main element should have complex content", (Object)wrapperType);
        String[] expectedLocalParts = new String[]{"description", "amount", "currentDate", "fingers"};
        QName[] expectedTypes = new QName[]{new QName(XSD_NAMESPACE, "string"), new QName(XSD_NAMESPACE, "float"), new QName(XSD_NAMESPACE, "dateTime"), new QName(WSDL_TYPES_NAMESPACE, "numberOfFingers")};
        List<Element> wrapperPartElements = wrapperType.getElements();
        Assert.assertEquals((String)"there should be as many child elements as parts in the message", (long)expectedTypes.length, (long)wrapperPartElements.size());
        int iElement = 0;
        while (iElement < wrapperPartElements.size()) {
            Element partElement = wrapperPartElements.get(iElement);
            Assert.assertEquals((String)"elements should be in the soap:body binding's namespace", (Object)WSDL_INPUT_NAMESPACE, (Object)partElement.getNamespace());
            Assert.assertEquals((String)"element names should match the parts in the WSDL", (Object)expectedLocalParts[iElement], (Object)partElement.getLocalPart());
            SimpleType partType = partElement.getType().getAsSimpleType();
            Assert.assertNotNull((String)("part " + expectedLocalParts[iElement] + " should have simple content"), (Object)partType);
            Assert.assertEquals((String)("part " + expectedLocalParts[iElement] + " should have the right type"), (Object)expectedTypes[iElement], (Object)partType.getQName());
            ++iElement;
        }
    }

    @Test
    public void generatedOutputElementIsCorrect() throws Exception {
        Element wrapperElement = this.fParser.getOutputElementForOperation(WSDL_SERVICE_QNAME, WSDL_PORT, WSDL_OPERATION);
        Assert.assertEquals((String)"wrapper element should have the right name", (Object)new QName(WSDL_SERVICE_NAMESPACE, WSDL_OPERATION), (Object)wrapperElement.getQName());
        ComplexType wrapperType = wrapperElement.getType().getAsComplexType();
        Assert.assertNotNull((String)"wrapper element should have complex content", (Object)wrapperType);
        List<Element> elements = wrapperType.getElements();
        Assert.assertEquals((String)"wrapper element should have as many children as parts in the message", (long)1L, (long)elements.size());
        Element partElement = elements.get(0);
        Assert.assertEquals((String)"part element should use the service NS and part name for its QName", (Object)new QName(WSDL_SERVICE_NAMESPACE, "result"), (Object)partElement.getQName());
        SimpleType partType = partElement.getType().getAsSimpleType();
        Assert.assertNotNull((String)"part type should have simple content", (Object)partType);
        Assert.assertEquals((String)"part type should be the right one", (Object)new QName(XSD_NAMESPACE, "string"), (Object)partType.getQName());
    }

    @Test
    public void generatedProcessingErrorFaultElementIsCorrect() throws Exception {
        Element docElement = this.fParser.getFaultElementForOperation(WSDL_SERVICE_QNAME, WSDL_PORT, WSDL_OPERATION, "processingError");
        Assert.assertEquals((String)"root element in the message should be the element in the WSDL", (Object)new QName(WSDL_TYPES_NAMESPACE, "errorCode"), (Object)docElement.getQName());
        SimpleType type = docElement.getType().getAsSimpleType();
        Assert.assertNotNull((String)"root element should have simple content", (Object)type);
        Assert.assertEquals((String)"root element should have the right content type", (Object)new QName(XSD_NAMESPACE, "int"), (Object)type.getQName());
    }

    @Test
    public void generatedInvalidQueryFaultElementIsCorrect() throws Exception {
        Element docElement = this.fParser.getFaultElementForOperation(WSDL_SERVICE_QNAME, WSDL_PORT, WSDL_OPERATION, "invalidQuery");
        Assert.assertEquals((String)"root element in the message should be the element in the WSDL", (Object)new QName(WSDL_TYPES_NAMESPACE, "reason"), (Object)docElement.getQName());
        SimpleType type = docElement.getType().getAsSimpleType();
        Assert.assertNotNull((String)"root element should have simple content", (Object)type);
        Assert.assertEquals((String)"root element should have the right content type", (Object)new QName(XSD_NAMESPACE, "string"), (Object)type.getQName());
    }

    @Test
    public void generatedFaultWithTypePartIsRejected() throws Exception {
        try {
            this.fParser.getFaultElementForOperation(WSDL_SERVICE_QNAME, WSDL_PORT, WSDL_OPERATION, "iambad");
            Assert.fail((String)"Faults declared using the type attribute should be rejected");
        }
        catch (InvalidInputException invalidInputException) {}
    }

    @Test
    public void rpcLitMessagesWithElementPartAreRejected() throws Exception {
        try {
            this.fParser.getInputElementForOperation(WSDL_SERVICE_QNAME, WSDL_PORT, WSDL_OPERATION_ONLYINPUT);
            Assert.fail((String)"rpc/lit messages with element parts should be rejected");
        }
        catch (InvalidInputException invalidInputException) {}
    }

    @Test
    public void generateImportedMsgWithInternalTypes() throws Exception {
        Element root = this.fParser.getFaultElementForOperation(WSDL_SERVICE_QNAME, WSDL_PORT, WSDL_OPERATION, "importTest");
        Assert.assertEquals((String)"root element should have the right name", (Object)new QName(WSDL_IMPORT_NAMESPACE, "importTest"), (Object)root.getQName());
        SimpleType type = root.getType().getAsSimpleType();
        Assert.assertNotNull((String)"root element should have simple content", (Object)type);
        Assert.assertEquals((String)"root element should have the right content type", (Object)new QName(XSD_NAMESPACE, "int"), (Object)type.getQName());
    }

    @Test
    public void generateCustomFaultForOneWayOpProducesCorrectException() throws Exception {
        try {
            this.fParser.getFaultElementForOperation(WSDL_SERVICE_QNAME, WSDL_PORT, WSDL_OPERATION_ONLYINPUT, null);
            Assert.fail((String)"Generating a custom fault should throw a 'no element definition' exception even for operations without declared faults");
        }
        catch (NoElementDefinitionExistsException noElementDefinitionExistsException) {}
    }
}

