/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.util;

import net.bpelunit.toolsupport.ToolSupportActivator;
import net.bpelunit.toolsupport.editors.BPELUnitEditor;
import net.bpelunit.toolsupport.util.WSDLReadingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class WSDLFileValidator
implements ISelectionStatusValidator {
    private BPELUnitEditor fEditor;

    public WSDLFileValidator(BPELUnitEditor editor) {
        this.fEditor = editor;
    }

    public IStatus validate(Object[] selection) {
        if (selection.length != 1 || !(selection[0] instanceof IFile)) {
            return new Status(4, ToolSupportActivator.getPluginId(), 0, "Please select a WSDL file", null);
        }
        try {
            IFile file = (IFile)selection[0];
            this.fEditor.getWsdlForFile(file.getProjectRelativePath().toString());
        }
        catch (WSDLReadingException e) {
            String msg = String.valueOf(e.getMessage()) + (e.getCause() != null ? ": " + e.getCause() : "");
            return new Status(4, ToolSupportActivator.getPluginId(), 0, msg, null);
        }
        return new Status(0, ToolSupportActivator.getPluginId(), 0, "", null);
    }
}

