/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.editors.wizards.pages;

import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import net.bpelunit.framework.xml.suite.XMLActivity;
import net.bpelunit.framework.xml.suite.XMLSoapActivity;
import net.bpelunit.toolsupport.editors.wizards.ActivityEditMode;
import net.bpelunit.toolsupport.editors.wizards.ReceiveSendSyncActivityWizard;
import net.bpelunit.toolsupport.editors.wizards.WizardPageCode;
import net.bpelunit.toolsupport.editors.wizards.components.IComponentListener;
import net.bpelunit.toolsupport.editors.wizards.components.OperationDataComponent;
import net.bpelunit.toolsupport.editors.wizards.fields.DialogField;
import net.bpelunit.toolsupport.editors.wizards.pages.ActivityWizardPage;
import net.bpelunit.toolsupport.util.schema.InvalidInputException;
import net.bpelunit.toolsupport.util.schema.NoElementDefinitionExistsException;
import net.bpelunit.toolsupport.util.schema.NoSuchOperationException;
import net.bpelunit.toolsupport.util.schema.WSDLParser;
import net.bpelunit.toolsupport.util.schema.nodes.Element;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;

public class OperationWizardPage
extends ActivityWizardPage
implements IComponentListener {
    private XMLSoapActivity fOperationActivity;
    private OperationDataComponent fOperationsComponent;
    private String elementError;
    private String elementWarning;

    public OperationWizardPage(XMLSoapActivity operationActivity, ActivityEditMode mode, String pageName) {
        super(pageName, mode);
        this.fOperationActivity = operationActivity;
        this.setDescription("Enter an operation and the data to send.");
    }

    @Override
    protected void createFieldControls(Composite composite, int nColumns) {
        this.fOperationsComponent = new OperationDataComponent((IWizardPage)this, this.getFontMetrics());
        this.fOperationsComponent.init(this.fOperationActivity);
        this.fOperationsComponent.createControls(composite, nColumns);
        this.fOperationsComponent.addComponentListener(this);
        this.valueChanged(null);
    }

    @Override
    public void valueChanged(DialogField field) {
        String operationError = this.fOperationsComponent.getErrorMessage();
        this.setErrorMessage(operationError != null ? operationError : this.elementError);
        this.setMessage(this.elementWarning, 2);
        this.setPageComplete(this.elementError == null && this.fOperationsComponent.isPageComplete());
    }

    public Definition getDefinition() {
        return this.fOperationsComponent.getDefinition();
    }

    public QName getService() {
        return this.fOperationsComponent.getService();
    }

    public String getPort() {
        return this.fOperationsComponent.getPort();
    }

    public String getOperation() {
        return this.fOperationsComponent.getOperation();
    }

    public boolean getSendFault() {
        return this.fOperationsComponent.getSendFault();
    }

    public String getSendFaultName() {
        return this.fOperationsComponent.getSendFaultName();
    }

    public boolean getReceiveFault() {
        return this.fOperationsComponent.getReceiveFault();
    }

    public WSDLParser getWSDLParser() {
        return this.fOperationsComponent.getWSDLParser();
    }

    protected XMLActivity getActivity() {
        return this.fOperationActivity;
    }

    public OperationDataComponent getOperationDataComponent() {
        return this.fOperationsComponent;
    }

    @Override
    public WizardPageCode getCode() {
        return WizardPageCode.OPERATION;
    }

    public Element getElementForOperation() throws InvalidInputException, NoSuchOperationException {
        Element element = null;
        WSDLParser parser = this.getWSDLParser();
        if (parser == null) {
            return null;
        }
        try {
            element = this.getSendFault() ? parser.getFaultElementForOperation(this.getService(), this.getPort(), this.getOperation(), this.getSendFaultName()) : (this.getWizard() instanceof ReceiveSendSyncActivityWizard ? parser.getOutputElementForOperation(this.getService(), this.getPort(), this.getOperation()) : parser.getInputElementForOperation(this.getService(), this.getPort(), this.getOperation()));
            this.elementError = null;
            this.elementWarning = null;
        }
        catch (InvalidInputException ex) {
            this.elementError = "Invalid input: " + ex.getLocalizedMessage();
            return null;
        }
        catch (NoElementDefinitionExistsException ex) {
            this.elementWarning = "Cannot generate sample element: " + ex.getLocalizedMessage();
            return null;
        }
        return element;
    }
}

