/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.editors.wizards.pages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bpelunit.framework.client.eclipse.dialog.DialogFieldValidator;
import net.bpelunit.framework.client.eclipse.dialog.Field;
import net.bpelunit.framework.client.eclipse.dialog.FieldBasedInputDialog;
import net.bpelunit.framework.client.eclipse.dialog.field.TextField;
import net.bpelunit.framework.client.eclipse.dialog.validate.NotEmptyValidator;
import net.bpelunit.framework.xml.suite.XMLTestSuite;
import net.bpelunit.toolsupport.editors.wizards.WizardPageCode;
import net.bpelunit.toolsupport.editors.wizards.fields.ListDialogField;
import net.bpelunit.toolsupport.editors.wizards.pages.StructuredActivityWizardPage;
import net.bpelunit.toolsupport.util.NamespaceDeclaration;
import net.bpelunit.toolsupport.util.NamespaceEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class NamespaceWizardPage
extends StructuredActivityWizardPage {
    private ListDialogField namespaceField;
    private Map<String, String> namespaces;
    private NamespaceEditor namespaceEditor;

    public NamespaceWizardPage(String pageName) {
        super(pageName);
        this.setTitle("Configure Namespaces");
        this.setDescription("Add or remove namespace declarations");
    }

    @Override
    public void handleAddPressed() {
        String[] edit = this.editProperty(null);
        if (edit != null && this.namespaceEditor.addNamespaceToSuite(edit[0], edit[1])) {
            this.recreateInput();
            this.enableButtonsForSelection(this.namespaceField, false);
        }
    }

    @Override
    public void handleEditPressed() {
        NamespaceDeclaration current = this.getSelectedNamespace();
        if (current == null) {
            return;
        }
        String[] edit = this.editProperty(current);
        if (edit != null && this.namespaceEditor.editNamespaceInSuite(current, edit[0], edit[1])) {
            this.recreateInput();
            this.enableButtonsForSelection(this.namespaceField, false);
        }
    }

    @Override
    public void handleRemovePressed() {
        NamespaceDeclaration prop = this.getSelectedNamespace();
        if (prop != null && this.namespaceEditor.removeNamespaceFromSuite(prop)) {
            this.recreateInput();
            this.enableButtonsForSelection(this.namespaceField, false);
        }
    }

    private NamespaceDeclaration getSelectedNamespace() {
        List<Object> selectedElements = this.namespaceField.getSelectedElements();
        if (selectedElements.size() > 0) {
            return (NamespaceDeclaration)selectedElements.get(0);
        }
        return null;
    }

    public void recreateInput() {
        this.namespaces = new HashMap<String, String>();
        this.namespaceEditor.getNamespacesFromSuite(this.namespaces);
        this.namespaceField.setElements(new ArrayList<Object>(this.getNamespacesAsList()));
    }

    private String[] editProperty(NamespaceDeclaration currentProperty) {
        String initialPrefix = currentProperty != null ? currentProperty.getPrefix() : null;
        String initialUrl = currentProperty != null ? currentProperty.getUrl() : null;
        String title = currentProperty != null ? "Edit a namespace" : "Add a namespace";
        FieldBasedInputDialog dialog = new FieldBasedInputDialog(this.getShell(), title);
        TextField prefixField = new TextField(dialog, "Prefix", initialPrefix, TextField.Style.SINGLE);
        prefixField.setValidator((DialogFieldValidator)new NotEmptyValidator("Prefix"));
        dialog.addField((Field)prefixField);
        TextField urlField = new TextField(dialog, "Url", initialUrl, TextField.Style.SINGLE);
        urlField.setValidator((DialogFieldValidator)new NotEmptyValidator("Url"));
        dialog.addField((Field)urlField);
        if (dialog.open() != 0) {
            return null;
        }
        String[] s = new String[]{prefixField.getSelection(), urlField.getSelection()};
        return s;
    }

    public void init(XMLTestSuite suite) {
        this.namespaceEditor = new NamespaceEditor(suite);
        StructuredActivityWizardPage.ListFieldListener copyListener = this.createListFieldListener();
        this.namespaceField = new ListDialogField(copyListener, this.fButtons, (IBaseLabelProvider)new OptionListLabelProvider());
        this.namespaceField.setDialogFieldListener(copyListener);
        this.namespaceField.setTableColumns(new ListDialogField.ColumnsDescription(new String[]{"Key", "Value"}, true));
        this.namespaceField.setLabelText(null);
        this.recreateInput();
        this.enableButtonsForSelection(this.namespaceField, false);
    }

    private List<NamespaceDeclaration> getNamespacesAsList() {
        ArrayList<NamespaceDeclaration> returner = new ArrayList<NamespaceDeclaration>();
        for (String prefix : this.namespaces.keySet()) {
            returner.add(new NamespaceDeclaration(prefix, this.namespaces.get(prefix)));
        }
        return returner;
    }

    @Override
    protected void createFieldControls(Composite composite, int nColumns) {
        this.namespaceField.doFillIntoGrid(composite, nColumns);
        GridData gd = (GridData)this.namespaceField.getListControl(null).getLayoutData();
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
    }

    @Override
    public WizardPageCode getCode() {
        return WizardPageCode.DEPLOYMENTOPTION;
    }

    private static class OptionListLabelProvider
    implements ITableLabelProvider {
        private OptionListLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof NamespaceDeclaration) {
                NamespaceDeclaration property = (NamespaceDeclaration)element;
                switch (columnIndex) {
                    case 0: {
                        return property.getPrefix();
                    }
                    case 1: {
                        return property.getUrl();
                    }
                }
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

