/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.editors.sections;

import net.bpelunit.framework.xml.suite.XMLTestSuite;
import net.bpelunit.toolsupport.editors.TestSuitePage;
import net.bpelunit.toolsupport.editors.formwidgets.ContextPart;
import net.bpelunit.toolsupport.editors.formwidgets.EntryAdapter;
import net.bpelunit.toolsupport.editors.formwidgets.TextEntry;
import net.bpelunit.toolsupport.editors.sections.BPELUnitSection;
import net.bpelunit.toolsupport.editors.wizards.NamespaceWizard;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class TestSuiteSection
extends BPELUnitSection
implements ContextPart,
IPropertyListener,
IHyperlinkListener {
    private TextEntry nameEntry;
    private TextEntry baseURLEntry;

    public TestSuiteSection(Composite parent, TestSuitePage page, FormToolkit toolkit, int style) {
        super(page, parent, toolkit, style);
        this.createClient(this.getSection(), toolkit);
        page.getEditor().addPropertyListener((IPropertyListener)this);
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        section.setText("Test Suite");
        section.setLayoutData((Object)new GridData(4, 1, true, false));
        section.setDescription("Enter a name and a base URL for this suite.");
        Composite content = toolkit.createComposite((Composite)section);
        TableWrapLayout layout = new TableWrapLayout();
        layout.rightMargin = toolkit.getBorderStyle() != 0 ? 0 : 2;
        layout.leftMargin = layout.rightMargin;
        layout.numColumns = 2;
        content.setLayout((Layout)layout);
        section.setClient((Control)content);
        this.createNameEntry(content, toolkit);
        this.createDescriptionEntry(content, toolkit);
        this.createText(content, "<form><p><a href=\"namespaceOptions\">Configure Namespace Prefixes...</a></p></form>", toolkit, this);
        toolkit.paintBordersFor(content);
    }

    private void createNameEntry(Composite content, FormToolkit toolkit) {
        this.nameEntry = new TextEntry(content, toolkit, "Suite Name", 4);
        this.nameEntry.setFormEntryListener(new EntryAdapter(this){

            @Override
            public void textValueChanged(TextEntry entry) {
                TestSuiteSection.this.getTestSuite().setName(entry.getValue());
                TestSuiteSection.this.markDirty();
            }
        });
    }

    private void createDescriptionEntry(Composite content, FormToolkit toolkit) {
        this.baseURLEntry = new TextEntry(content, toolkit, "Base URL", 4);
        this.baseURLEntry.setFormEntryListener(new EntryAdapter(this){

            @Override
            public void textValueChanged(TextEntry entry) {
                TestSuiteSection.this.getTestSuite().setBaseURL(entry.getValue());
                TestSuiteSection.this.markDirty();
            }
        });
    }

    public void refresh() {
        XMLTestSuite suite = this.getTestSuite();
        this.nameEntry.setValue(suite.getName());
        this.baseURLEntry.setValue(suite.getBaseURL());
        super.refresh();
    }

    @Override
    public void fireSaveNeeded() {
        this.markDirty();
    }

    public void propertyChanged(Object source, int propId) {
    }

    public void linkActivated(HyperlinkEvent e) {
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)new NamespaceWizard(this.getTestSuite()));
        if (dialog.open() == 0) {
            this.markDirty();
        }
    }

    public void linkEntered(HyperlinkEvent e) {
    }

    public void linkExited(HyperlinkEvent e) {
    }
}

