/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.editors.sections;

import net.bpelunit.framework.client.eclipse.dialog.DialogFieldValidator;
import net.bpelunit.framework.client.eclipse.dialog.Field;
import net.bpelunit.framework.client.eclipse.dialog.FieldBasedInputDialog;
import net.bpelunit.framework.client.eclipse.dialog.field.FileField;
import net.bpelunit.framework.client.eclipse.dialog.field.TextField;
import net.bpelunit.framework.client.eclipse.dialog.validate.NotEmptyValidator;
import net.bpelunit.framework.xml.suite.XMLDeploymentSection;
import net.bpelunit.framework.xml.suite.XMLPartnerDeploymentInformation;
import net.bpelunit.framework.xml.suite.XMLTestSuite;
import net.bpelunit.toolsupport.ToolSupportActivator;
import net.bpelunit.toolsupport.editors.TestSuitePage;
import net.bpelunit.toolsupport.editors.sections.ListSection;
import net.bpelunit.toolsupport.util.WSDLFileFilter;
import net.bpelunit.toolsupport.util.WSDLFileValidator;
import net.bpelunit.toolsupport.util.WSDLReadingException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PartnerSection
extends ListSection {
    private static final String OPTION_WSDL_FILE = "WSDL file";
    private static final String OPTION_NAME = "Name";

    public PartnerSection(Composite parent, TestSuitePage page, FormToolkit toolkit) {
        super(parent, toolkit, page);
        this.init();
    }

    private void init() {
        this.getViewer().setLabelProvider((IBaseLabelProvider)new PartnerLabelProvider());
        this.getViewer().setContentProvider((IContentProvider)new PartnerContentProvider());
    }

    @Override
    protected String getDescription() {
        return "Manage the partner processes.";
    }

    @Override
    protected String getName() {
        return "Partners";
    }

    public void refresh() {
        this.setViewerInput(this.getDeploymentXMLPart());
        super.refresh();
    }

    private XMLDeploymentSection getDeploymentXMLPart() {
        XMLTestSuite model = this.getTestSuite();
        return model.getDeployment();
    }

    @Override
    protected void addPressed() {
        FieldBasedInputDialog dialog = new FieldBasedInputDialog(this.getShell(), "Add a partner");
        TextField nameField = new TextField(dialog, OPTION_NAME, null, TextField.Style.SINGLE);
        nameField.setValidator((DialogFieldValidator)new NotEmptyValidator(OPTION_NAME));
        dialog.addField((Field)nameField);
        FileField fileField = new FileField(dialog, OPTION_WSDL_FILE, null, (ISelectionStatusValidator)new WSDLFileValidator(this.getEditor()), (ViewerFilter)new WSDLFileFilter(), this.getEditor().getCurrentProject(), this.getEditor().getCurrentDirectory());
        fileField.setValidator((DialogFieldValidator)new WsdlValidator());
        dialog.addField((Field)fileField);
        if (dialog.open() != 0) {
            return;
        }
        String name = nameField.getSelection();
        String file = fileField.getSelection();
        if (name != null && file != null && name.length() > 0 && file.length() > 0) {
            XMLPartnerDeploymentInformation information = this.getDeploymentXMLPart().addNewPartner();
            information.setName(name);
            information.setWsdl(file);
            this.manageTargetNamespace(file);
            this.getViewer().refresh();
            this.markDirty();
        }
    }

    @Override
    protected void editPressed() {
        XMLPartnerDeploymentInformation currentlySelectedItem = this.getCurrentlySelectedItem();
        FieldBasedInputDialog dialog = new FieldBasedInputDialog(this.getShell(), "Edit a partner");
        TextField nameField = new TextField(dialog, OPTION_NAME, currentlySelectedItem.getName(), TextField.Style.SINGLE);
        nameField.setValidator((DialogFieldValidator)new NotEmptyValidator(OPTION_NAME));
        dialog.addField((Field)nameField);
        FileField fileField = new FileField(dialog, OPTION_WSDL_FILE, currentlySelectedItem.getWsdl(), (ISelectionStatusValidator)new WSDLFileValidator(this.getEditor()), (ViewerFilter)new WSDLFileFilter(), this.getEditor().getCurrentProject(), this.getEditor().getCurrentDirectory());
        fileField.setValidator((DialogFieldValidator)new WsdlValidator());
        dialog.addField((Field)fileField);
        if (dialog.open() != 0) {
            return;
        }
        String name = nameField.getSelection();
        String file = fileField.getSelection();
        if (name != null && file != null && name.length() > 0 && file.length() > 0) {
            currentlySelectedItem.setName(name);
            currentlySelectedItem.setWsdl(file);
            this.manageTargetNamespace(file);
            this.getViewer().refresh();
            this.markDirty();
        }
    }

    @Override
    protected void removePressed() {
        XMLPartnerDeploymentInformation currentlySelectedItem = this.getCurrentlySelectedItem();
        XMLPartnerDeploymentInformation[] partnerList = this.getDeploymentXMLPart().getPartnerArray();
        int i = 0;
        XMLPartnerDeploymentInformation[] xMLPartnerDeploymentInformationArray = partnerList;
        int n = partnerList.length;
        int n2 = 0;
        while (n2 < n) {
            XMLPartnerDeploymentInformation information = xMLPartnerDeploymentInformationArray[n2];
            if (information.equals(currentlySelectedItem)) {
                this.getDeploymentXMLPart().removePartner(i);
                break;
            }
            ++i;
            ++n2;
        }
        this.getViewer().refresh();
        this.setEditRemoveDuplicateEnabled(false);
        this.markDirty();
    }

    private XMLPartnerDeploymentInformation getCurrentlySelectedItem() {
        return (XMLPartnerDeploymentInformation)this.getViewerSelection();
    }

    @Override
    protected void itemSelected(Object item) {
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        MenuManager newMenu = new MenuManager("&New");
        this.createAction((IMenuManager)newMenu, "Partner", new Action(){

            public void run() {
                PartnerSection.this.addPressed();
            }
        });
        manager.add((IContributionItem)newMenu);
        ISelection selection = this.getViewer().getSelection();
        IStructuredSelection ssel = (IStructuredSelection)selection;
        if (ssel.size() == 1) {
            manager.add((IContributionItem)new Separator());
            this.createAction(manager, "&Edit", new Action(){

                public void run() {
                    PartnerSection.this.editPressed();
                }
            });
            manager.add((IContributionItem)new Separator());
            this.createAction(manager, "&Remove", new Action(){

                public void run() {
                    PartnerSection.this.removePressed();
                }
            });
        }
    }

    private class PartnerContentProvider
    implements IStructuredContentProvider {
        private PartnerContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof XMLDeploymentSection) {
                XMLDeploymentSection element = (XMLDeploymentSection)inputElement;
                return element.getPartnerArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class PartnerLabelProvider
    implements ILabelProvider {
        private PartnerLabelProvider() {
        }

        public Image getImage(Object element) {
            return ToolSupportActivator.getImage("img_deployer");
        }

        public String getText(Object element) {
            if (element instanceof XMLPartnerDeploymentInformation) {
                return ((XMLPartnerDeploymentInformation)element).getName();
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class WsdlValidator
    extends DialogFieldValidator {
        private WsdlValidator() {
        }

        public String validate(String value) {
            if ("".equals(value)) {
                return "WSDL file must be specified.";
            }
            try {
                PartnerSection.this.getEditor().getWsdlForFile(value);
            }
            catch (WSDLReadingException e) {
                String msg = String.valueOf(e.getMessage()) + (e.getCause() != null ? ": " + e.getCause() : "");
                return msg;
            }
            return null;
        }
    }
}

