/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.client.eclipse.views;

import net.bpelunit.framework.client.eclipse.views.BPELUnitView;
import net.bpelunit.framework.model.test.report.ArtefactStatus;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CounterPanel
extends Composite {
    private Text fNumberOfRuns;
    private Text fNumberOfErrors;
    private Text fNumberOfFailures;
    private int fTotalRuns;
    private int fRuns;
    private int fErrors;
    private int fFailures;
    private final Image fErrorIcon = BPELUnitView.createImage("icons/error_ovr.gif");
    private final Image fFailureIcon = BPELUnitView.createImage("icons/failed_ovr.gif");

    public CounterPanel(Composite parent) {
        super(parent, 64);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 9;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.fNumberOfRuns = this.createLabel("Runs:", null, " 0/0  ");
        this.fNumberOfErrors = this.createLabel("Errors:", this.fErrorIcon, " 0 ");
        this.fNumberOfFailures = this.createLabel("Failures:", this.fFailureIcon, " 0 ");
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CounterPanel.this.disposeIcons();
            }
        });
    }

    private void disposeIcons() {
        this.fErrorIcon.dispose();
        this.fFailureIcon.dispose();
    }

    private Text createLabel(String name, Image image, String init) {
        Label label = new Label((Composite)this, 0);
        if (image != null) {
            image.setBackground(label.getBackground());
            label.setImage(image);
        }
        label.setLayoutData((Object)new GridData(32));
        label = new Label((Composite)this, 0);
        label.setText(name);
        label.setLayoutData((Object)new GridData(32));
        Text value = new Text((Composite)this, 8);
        value.setText(init);
        value.setBackground(this.getDisplay().getSystemColor(22));
        value.setLayoutData((Object)new GridData(800));
        return value;
    }

    public void reset(String name, int total) {
        this.fErrors = 0;
        this.fFailures = 0;
        this.fTotalRuns = total;
        this.fRuns = 0;
        this.updateLabels();
    }

    public void addRun(ArtefactStatus.StatusCode code) {
        switch (code) {
            case ERROR: {
                ++this.fErrors;
                break;
            }
            case FAILED: {
                ++this.fFailures;
            }
        }
        ++this.fRuns;
        this.updateLabels();
    }

    private void updateLabels() {
        this.fNumberOfErrors.setText(Integer.toString(this.fErrors));
        this.fNumberOfFailures.setText(Integer.toString(this.fFailures));
        this.fNumberOfRuns.setText(String.valueOf(Integer.toString(this.fRuns)) + "/" + Integer.toString(this.fTotalRuns));
        this.redraw();
    }
}

