/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.client.eclipse.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bpelunit.framework.client.eclipse.dialog.FieldBasedInputDialog;
import net.bpelunit.framework.client.eclipse.dialog.field.DeployerOptionModifyListener;
import net.bpelunit.framework.client.eclipse.dialog.field.SelectionField;
import net.bpelunit.framework.client.eclipse.dialog.field.TextField;
import net.bpelunit.framework.client.eclipse.dialog.validate.NotEmptyValidator;
import net.bpelunit.framework.client.model.ConfigurationOption;
import net.bpelunit.framework.client.model.DeployerExtension;
import net.bpelunit.framework.client.model.ExtensionUtil;
import net.bpelunit.framework.control.ext.IBPELDeployer;
import net.bpelunit.framework.control.util.ExtensionRegistry;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class OptionTableFieldEditor
extends FieldEditor {
    private TableViewer fTable;
    private Composite fButtonBox;
    private Button fAddButton;
    private Button fEditButton;
    private Button fRemoveButton;
    private SelectionListener fSelectionListener;
    private DeployerExtension fCurrentDeployer;
    private List<ConfigurationOption> fConfigurationOptions;
    private boolean fChanged;
    private Class<? extends IBPELDeployer> fCurrentDeployerClass;

    public OptionTableFieldEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.createControl(parent);
        this.fConfigurationOptions = new ArrayList<ConfigurationOption>();
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.fTable.getTable().getLayoutData()).horizontalSpan = numColumns - 1;
    }

    private void createButtons(Composite box) {
        this.fAddButton = this.createPushButton(box, "&Add...");
        this.fEditButton = this.createPushButton(box, "&Edit...");
        this.fRemoveButton = this.createPushButton(box, "&Remove");
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Composite innerComp = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        innerComp.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        innerComp.setLayoutData((Object)gridData);
        Label control = this.getLabelControl(innerComp);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
        this.fTable = this.getTableControl(innerComp);
        gd = new GridData(1808);
        gd.verticalAlignment = 4;
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.fTable.getTable().setLayoutData((Object)gd);
        this.fButtonBox = this.getButtonBoxControl(innerComp);
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.fButtonBox.setLayoutData((Object)gd);
        this.updateButtons();
        this.fChanged = false;
    }

    public TableViewer getTableControl(Composite parent) {
        if (this.fTable == null) {
            this.fTable = new TableViewer(parent, 68356);
            this.fTable.getTable().setFont(parent.getFont());
            this.fTable.getTable().setHeaderVisible(true);
            this.fTable.setLabelProvider((IBaseLabelProvider)new OptionLabelProvider());
            this.fTable.setContentProvider((IContentProvider)new OptionContentProvider());
            TableColumn keyColumn = new TableColumn(this.fTable.getTable(), 16384);
            keyColumn.setText("Option");
            keyColumn.setWidth(150);
            TableColumn valueColumn = new TableColumn(this.fTable.getTable(), 16384);
            valueColumn.setText("Value");
            valueColumn.setWidth(200);
            this.fTable.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    OptionTableFieldEditor.this.handleTableSelectionChanged(event);
                }
            });
        } else {
            this.checkParent((Control)this.fTable.getTable(), parent);
        }
        return this.fTable;
    }

    public Composite getButtonBoxControl(Composite parent) {
        if (this.fButtonBox == null) {
            this.fButtonBox = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            this.fButtonBox.setLayout((Layout)layout);
            this.createButtons(this.fButtonBox);
            this.fButtonBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    OptionTableFieldEditor.this.fAddButton = null;
                    OptionTableFieldEditor.this.fEditButton = null;
                    OptionTableFieldEditor.this.fRemoveButton = null;
                    OptionTableFieldEditor.this.fButtonBox = null;
                }
            });
        } else {
            this.checkParent((Control)this.fButtonBox, parent);
        }
        return this.fButtonBox;
    }

    protected void doLoad() {
        this.fConfigurationOptions.clear();
        String s = this.getPreferenceStore().getString(this.getPreferenceName());
        Map<String, String> map = ExtensionUtil.deserializeMap(s);
        for (String key : map.keySet()) {
            this.fConfigurationOptions.add(new ConfigurationOption(key, map.get(key)));
        }
        if (this.fTable != null) {
            this.fTable.setInput(this.fConfigurationOptions);
        }
    }

    protected void doLoadDefault() {
        this.fConfigurationOptions.clear();
        if (this.fTable != null) {
            this.fTable.setInput(this.fConfigurationOptions);
        }
    }

    protected void doStore() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (ConfigurationOption o : this.fConfigurationOptions) {
            map.put(o.getKey(), o.getValue());
        }
        String s = ExtensionUtil.serializeMap(map);
        if (s != null) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), s);
            this.fChanged = false;
        }
    }

    public int getNumberOfControls() {
        return 2;
    }

    private Button createPushButton(Composite parent, String key) {
        Button button = new Button(parent, 8);
        button.setText(key);
        button.setFont(parent.getFont());
        GridData data = new GridData(768);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        button.addSelectionListener(this.getSelectionListener());
        return button;
    }

    private SelectionListener getSelectionListener() {
        if (this.fSelectionListener == null) {
            this.createSelectionListener();
        }
        return this.fSelectionListener;
    }

    public void createSelectionListener() {
        this.fSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Widget widget = event.widget;
                if (widget == OptionTableFieldEditor.this.fAddButton) {
                    OptionTableFieldEditor.this.addPressed();
                } else if (widget == OptionTableFieldEditor.this.fRemoveButton) {
                    OptionTableFieldEditor.this.removePressed();
                } else if (widget == OptionTableFieldEditor.this.fEditButton) {
                    OptionTableFieldEditor.this.editPressed();
                }
            }
        };
    }

    protected void removePressed() {
        IStructuredSelection sel = (IStructuredSelection)this.fTable.getSelection();
        this.fTable.getControl().setRedraw(false);
        for (ConfigurationOption var : sel) {
            this.fConfigurationOptions.remove(var);
            this.fChanged = true;
        }
        this.fTable.getControl().setRedraw(true);
        this.fTable.refresh();
        this.updateButtons();
    }

    private void addPressed() {
        String[] edit = this.editProperty(null);
        if (edit != null) {
            this.addVariable(new ConfigurationOption(edit[0].trim(), edit[1].trim()));
            this.updateButtons();
            this.fChanged = true;
        }
    }

    private String[] editProperty(ConfigurationOption currentProperty) {
        String initialKey = currentProperty != null ? currentProperty.getKey() : null;
        String initialValue = currentProperty != null ? currentProperty.getValue() : null;
        String title = initialKey == null ? "Add Property" : "Edit Property";
        FieldBasedInputDialog dialog = new FieldBasedInputDialog(this.getShell(), title);
        String[] options = ExtensionRegistry.getPossibleConfigurationOptions(this.fCurrentDeployerClass, (boolean)false).toArray(new String[0]);
        SelectionField selField = new SelectionField(dialog, "Key", initialKey, "Keys...", options);
        selField.setValidator(new NotEmptyValidator("Key"));
        dialog.addField(selField);
        TextField valueField = new TextField(dialog, "Value", initialValue, TextField.Style.SINGLE);
        valueField.setValidator(new NotEmptyValidator("Value"));
        dialog.addField(valueField);
        selField.addModifyListener(new DeployerOptionModifyListener(selField, valueField, this.fCurrentDeployerClass));
        if (dialog.open() != 0) {
            return null;
        }
        String[] s = new String[]{selField.getSelection(), valueField.getSelection()};
        return s;
    }

    protected boolean addVariable(ConfigurationOption variable) {
        String name = variable.getKey();
        for (ConfigurationOption existingVariable : this.fConfigurationOptions) {
            if (!existingVariable.getKey().equals(name)) continue;
            boolean overWrite = MessageDialog.openQuestion((Shell)this.fTable.getTable().getShell(), (String)"Overwrite option?", (String)("A variable named " + name + " already exists. Overwrite?"));
            if (!overWrite) {
                return false;
            }
            this.fConfigurationOptions.remove(existingVariable);
            break;
        }
        this.fConfigurationOptions.add(variable);
        this.fChanged = true;
        this.fTable.refresh();
        this.updateButtons();
        return true;
    }

    private void editPressed() {
        IStructuredSelection sel = (IStructuredSelection)this.fTable.getSelection();
        ConfigurationOption var = (ConfigurationOption)sel.getFirstElement();
        if (var == null) {
            return;
        }
        String[] edit = this.editProperty(var);
        if (edit != null) {
            String originalName = var.getKey();
            String name = edit[0];
            String value = edit[1];
            if (!originalName.equals(name)) {
                if (this.addVariable(new ConfigurationOption(name, value))) {
                    this.fConfigurationOptions.remove(var);
                    this.fTable.refresh();
                }
            } else {
                var.setValue(value);
                this.fChanged = true;
                this.fTable.update((Object)var, null);
            }
            this.updateButtons();
        }
    }

    private Shell getShell() {
        return this.fTable.getTable().getShell();
    }

    protected void handleTableSelectionChanged(SelectionChangedEvent event) {
        this.updateButtons();
    }

    private void updateButtons() {
        int size = ((IStructuredSelection)this.fTable.getSelection()).size();
        this.fEditButton.setEnabled(size == 1);
        this.fRemoveButton.setEnabled(size > 0);
    }

    public void setDeployer(DeployerExtension deployerExtension) {
        if (this.fChanged && MessageDialog.openQuestion((Shell)this.fTable.getTable().getShell(), (String)"Deployer Options Changed", (String)"You have made changes to this deployer. Save the changes?")) {
            this.doStore();
        }
        this.fCurrentDeployer = deployerExtension;
        try {
            this.fCurrentDeployerClass = deployerExtension.createNew().getClass();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.fCurrentDeployerClass = null;
        }
        this.fChanged = false;
        if (this.getPreferenceStore() != null) {
            this.doLoad();
        }
        this.updateButtons();
    }

    public String getPreferenceName() {
        return this.fCurrentDeployer.getId();
    }

    class OptionContentProvider
    implements IStructuredContentProvider {
        OptionContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class OptionLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        OptionLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = null;
            if (element != null) {
                ConfigurationOption var = (ConfigurationOption)element;
                switch (columnIndex) {
                    case 0: {
                        result = var.getKey();
                        break;
                    }
                    case 1: {
                        result = var.getValue();
                    }
                }
            }
            return result;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

