/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.client.eclipse.launch;

import net.bpelunit.framework.client.eclipse.BPELUnitActivator;
import net.bpelunit.framework.client.eclipse.launch.LaunchConstants;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class BPELLaunchMainTab
extends AbstractLaunchConfigurationTab {
    private Text fProjText;
    private Button fProjButton;
    private Text fSuiteText;
    private Button fSearchButton;

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        topLayout.verticalSpacing = 0;
        comp.setLayout((Layout)topLayout);
        comp.setFont(font);
        this.createProjectSection(comp);
        this.createVerticalSpacer(comp, 1);
        this.createSuiteSection(comp, "&BPEL Test Suite File:", new Button[0]);
    }

    public String getName() {
        return "BPEL Test Suite";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.updateProjectFromConfig(configuration);
        this.updateSuiteFromConfig(configuration);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(LaunchConstants.ATTR_PROJECT_NAME, this.fProjText.getText().trim());
        configuration.setAttribute(LaunchConstants.ATTR_SUITE_FILE_NAME, this.fSuiteText.getText().trim());
        this.mapResources(configuration);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        IFile selectedFile = this.getContext();
        if (selectedFile != null) {
            this.initializeProject(selectedFile, configuration);
        } else {
            configuration.setAttribute(LaunchConstants.ATTR_PROJECT_NAME, "");
        }
        this.initializeSuiteAndName(selectedFile, configuration);
    }

    protected void createProjectSection(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        group.setText("&Project:");
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setFont(font);
        this.fProjText = new Text((Composite)group, 2052);
        gd = new GridData(768);
        this.fProjText.setLayoutData((Object)gd);
        this.fProjText.setFont(font);
        this.fProjText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BPELLaunchMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fProjButton = this.createPushButton((Composite)group, "&Browse...", null);
        this.fProjButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                BPELLaunchMainTab.this.handleProjectButtonSelected();
            }
        });
    }

    protected void handleProjectButtonSelected() {
        IProject project = this.chooseProject();
        if (project == null) {
            return;
        }
        String projectName = project.getName();
        this.fProjText.setText(projectName);
    }

    private IProject chooseProject() {
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle("Project Selection");
        dialog.setMessage("Select a project to constrain your search.");
        dialog.setElements((Object[])this.getWorkspaceRoot().getProjects());
        IProject project = this.getProject();
        if (project != null) {
            dialog.setInitialSelections(new Object[]{project});
        }
        if (dialog.open() == 0) {
            return (IProject)dialog.getFirstResult();
        }
        return null;
    }

    protected IProject getProject() {
        String projectName = this.fProjText.getText().trim();
        if (projectName.length() < 1) {
            return null;
        }
        return this.getWorkspaceRoot().getProject(projectName);
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected void createSuiteSection(Composite parent, String text, Button[] buttons) {
        Font font = parent.getFont();
        Group mainGroup = new Group(parent, 0);
        mainGroup.setText(text);
        GridData gd = new GridData(768);
        mainGroup.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        mainGroup.setLayout((Layout)layout);
        mainGroup.setFont(font);
        this.fSuiteText = new Text((Composite)mainGroup, 2052);
        gd = new GridData(768);
        this.fSuiteText.setLayoutData((Object)gd);
        this.fSuiteText.setFont(font);
        this.fSuiteText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BPELLaunchMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fSearchButton = this.createPushButton((Composite)mainGroup, "&Search...", null);
        this.fSearchButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                BPELLaunchMainTab.this.handleSearchButtonSelected();
            }
        });
        if (buttons != null) {
            Button[] buttonArray = buttons;
            int n = buttons.length;
            int n2 = 0;
            while (n2 < n) {
                Button element = buttonArray[n2];
                element.setParent((Composite)mainGroup);
                ++n2;
            }
        }
    }

    protected void handleSearchButtonSelected() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle("Select a .bpts file:");
        dialog.setMessage("Select the .bpts file to run:");
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setSorter((ViewerSorter)new ResourceSorter(1));
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                IFile file;
                return !(element instanceof IFile) || (file = (IFile)element).getFileExtension().equals("bpts");
            }
        });
        dialog.setAllowMultiple(false);
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                IFile file;
                Object first;
                if (selection != null && selection.length > 0 && (first = selection[0]) instanceof IFile && (file = (IFile)first).getFileExtension().equals("bpts")) {
                    return Status.OK_STATUS;
                }
                return new Status(4, BPELUnitActivator.getUniqueIdentifier(), -1, "Select a .bpts file.", null);
            }
        });
        if (dialog.open() == 0) {
            IResource resource = (IResource)dialog.getFirstResult();
            if (!(resource instanceof IFile) || !resource.getFileExtension().equals("bpts")) {
                MessageDialog.openError((Shell)this.getShell(), (String)"BPELUnit Test Suite", (String)"Must select a file with a .bpts ending");
            } else {
                this.fSuiteText.setText(resource.getProjectRelativePath().toString());
            }
        }
    }

    protected void updateSuiteFromConfig(ILaunchConfiguration config) {
        String suiteName = "";
        try {
            suiteName = config.getAttribute(LaunchConstants.ATTR_SUITE_FILE_NAME, "");
        }
        catch (CoreException ce) {
            BPELUnitActivator.log(ce);
        }
        this.fSuiteText.setText(suiteName);
    }

    private void updateProjectFromConfig(ILaunchConfiguration config) {
        String projectName = "";
        try {
            projectName = config.getAttribute(LaunchConstants.ATTR_PROJECT_NAME, "");
        }
        catch (CoreException ce) {
            BPELUnitActivator.log(ce);
        }
        this.fProjText.setText(projectName);
    }

    protected void mapResources(ILaunchConfigurationWorkingCopy config) {
        IProject project = this.getProject();
        IResource[] resources = null;
        if (project != null) {
            resources = new IResource[]{project.getProject()};
        }
        config.setMappedResources(resources);
    }

    protected IFile getContext() {
        IWorkbenchPage page = BPELLaunchMainTab.getActivePage();
        if (page != null) {
            Object obj;
            IStructuredSelection ss;
            ISelection selection = page.getSelection();
            if (selection instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty() && (obj = ss.getFirstElement()) instanceof IFile) {
                return (IFile)obj;
            }
            IEditorPart part = page.getActiveEditor();
            if (part != null) {
                IEditorInput input = part.getEditorInput();
                return (IFile)input.getAdapter(IFile.class);
            }
        }
        return null;
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow w = BPELLaunchMainTab.getActiveWorkbenchWindow();
        if (w != null) {
            return w.getActivePage();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return BPELUnitActivator.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    protected void initializeProject(IFile file, ILaunchConfigurationWorkingCopy config) {
        IProject project = file.getProject();
        String name = null;
        if (project != null && project.exists()) {
            name = project.getName();
        }
        config.setAttribute(LaunchConstants.ATTR_PROJECT_NAME, name);
    }

    protected void initializeSuiteAndName(IFile file, ILaunchConfigurationWorkingCopy config) {
        String name = null;
        if (file != null && file.getFileExtension().equals("bpts")) {
            name = file.getProjectRelativePath().toString();
        }
        if (name == null) {
            name = "";
        }
        config.setAttribute(LaunchConstants.ATTR_SUITE_FILE_NAME, name);
        if (name.length() > 0) {
            int index = name.lastIndexOf(46);
            if (index > 0) {
                name = name.substring(0, index);
            }
            name = this.getLaunchConfigurationDialog().generateName(name);
            config.rename(name);
        }
    }

    public Image getImage() {
        return BPELUnitActivator.getImage("bpel_obj");
    }

    protected static Image createImage(String path) {
        return BPELUnitActivator.getImageDescriptor(path).createImage();
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String fileName = this.fProjText.getText().trim();
        IProject project = null;
        if (fileName.length() > 0) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IStatus status = workspace.validateName(fileName, 4);
            if (status.isOK()) {
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(fileName);
                if (!project.exists()) {
                    this.setErrorMessage("Project " + fileName + " does not exist");
                    return false;
                }
                if (!project.isOpen()) {
                    this.setErrorMessage("Project " + fileName + " is closed");
                    return false;
                }
            } else {
                this.setErrorMessage("Illegal project name: " + status.getMessage());
                return false;
            }
        }
        if ((fileName = this.fSuiteText.getText().trim()).length() == 0) {
            this.setErrorMessage("Test Suite file not specified.");
            return false;
        }
        if (project != null && !project.getFile(fileName).exists()) {
            this.setErrorMessage("Test Suite " + fileName + " does not exist.");
            return false;
        }
        return true;
    }
}

