/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.client.eclipse.dialog.field;

import net.bpelunit.framework.client.eclipse.dialog.Field;
import net.bpelunit.framework.client.eclipse.dialog.FieldBasedInputDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class TextField
extends Field {
    private Text fText;
    private Style fStyle;
    private String fCurrentSelection;

    public TextField(FieldBasedInputDialog dialog, String labelText, String initialValue, Style style) {
        super(dialog, labelText, initialValue);
        this.fStyle = style;
    }

    @Override
    protected void createControl(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(this.getLabelText());
        GridData labelGD = new GridData();
        labelGD.horizontalAlignment = 32;
        labelGD.verticalAlignment = 0x1000000;
        label.setLayoutData((Object)labelGD);
        int flags = 0x800 | (this.fStyle == Style.SINGLE ? 4 : 578);
        this.fText = new Text(parent, flags);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 200;
        if (this.fStyle == Style.MULTI) {
            gridData.verticalAlignment = 4;
            gridData.heightHint = 50;
        }
        this.fText.setLayoutData((Object)gridData);
        label.setSize(label.getSize().x, this.fText.getSize().y);
        if (this.getInitialValue() != null) {
            this.fCurrentSelection = this.getInitialValue();
            this.fText.setText(this.getInitialValue());
        }
        this.fCurrentSelection = this.fText.getText();
        this.fText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TextField.this.fCurrentSelection = TextField.this.fText.getText();
                TextField.this.getDialog().validateFields();
            }
        });
    }

    @Override
    public String getSelection() {
        return this.fCurrentSelection;
    }

    public void setText(String text) {
        this.fText.setText(text);
    }

    public static enum Style {
        SINGLE,
        MULTI;

    }
}

