/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.client.eclipse;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import net.bpelunit.framework.client.eclipse.EclipseBPELUnitRunner;
import net.bpelunit.framework.client.eclipse.views.BPELUnitCoverageResultView;
import net.bpelunit.framework.client.eclipse.views.BPELUnitView;
import net.bpelunit.framework.client.model.TestRunSession;
import net.bpelunit.framework.coverage.result.statistic.IFileStatistic;
import net.bpelunit.framework.exception.ConfigurationException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class BPELUnitActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "net.bpelunit.framework.client.eclipse";
    public static final String FRAMEWORK_BUNDLE_SYMBOLICNAME = "net.bpelunit.framework";
    public static final String BPELUNIT_VIEW_ID = "net.bpelunit.framework.client.eclipse.views.BPELUnitView";
    public static final String BPELUNIT_COVERAGE_VIEW_ID = "net.bpelunit.framework.client.eclipse.views.BPELUnitCoverageResultView";
    public static final String BPELUNIT_CONSOLE_ID = "BPELUnitConsole";
    public static final int INTERNAL_ERROR = 150;
    public static final String INTERNAL_ERROR_MESSAGE = "Internal Error";
    public static final String IMAGE_INFO = "info_obj";
    public static final String IMAGE_WARNING = "warning_obj";
    public static final String IMAGE_ERROR = "error_obj";
    public static final String IMAGE_BPEL = "bpel_obj";
    private static BPELUnitActivator fgPlugin;
    private TestRunSession fCurrentSession = null;
    private EclipseBPELUnitRunner fUnitCore;

    public BPELUnitActivator() {
        fgPlugin = this;
    }

    public static String getUniqueIdentifier() {
        return PLUGIN_ID;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        fgPlugin = null;
        super.stop(context);
    }

    public static BPELUnitActivator getDefault() {
        return fgPlugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return BPELUnitActivator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static void log(IStatus status) {
        BPELUnitActivator.getDefault().getLog().log(status);
    }

    public static void logErrorMessage(String message) {
        BPELUnitActivator.log((IStatus)new Status(4, BPELUnitActivator.getUniqueIdentifier(), 150, message, null));
    }

    public static void log(Throwable e) {
        BPELUnitActivator.log((IStatus)new Status(4, BPELUnitActivator.getUniqueIdentifier(), 150, INTERNAL_ERROR_MESSAGE, e));
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return BPELUnitActivator.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public void registerLaunchSession(final TestRunSession session) {
        if (this.fCurrentSession != null) {
            this.fCurrentSession.stopTest();
            while (this.fCurrentSession != null) {
                try {
                    Thread.sleep(150L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.fCurrentSession = session;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    BPELUnitActivator.this.getBPELUnitView().registerLaunchSession(session);
                }
                catch (PartInitException e) {
                    BPELUnitActivator.log(e);
                }
            }
        });
    }

    public void deregisterLaunchSession(final TestRunSession session) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    BPELUnitActivator.this.getBPELUnitView().deregisterLaunchSession(session);
                }
                catch (PartInitException e) {
                    BPELUnitActivator.log(e);
                }
            }
        });
        this.fCurrentSession = null;
    }

    public void showCoverageResult(final List<String> testCases, final List<IFileStatistic> statistics, final String string) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    BPELUnitActivator.this.getBPELUnitCoverageView().setData(testCases, statistics, string);
                }
                catch (PartInitException e) {
                    BPELUnitActivator.log(e);
                }
            }
        });
    }

    private BPELUnitCoverageResultView getBPELUnitCoverageView() throws PartInitException {
        return (BPELUnitCoverageResultView)BPELUnitActivator.getActiveWorkbenchWindow().getActivePage().showView(BPELUNIT_COVERAGE_VIEW_ID);
    }

    private BPELUnitCoverageResultView findBPELUnitCoverageView() throws PartInitException {
        return (BPELUnitCoverageResultView)BPELUnitActivator.getActiveWorkbenchWindow().getActivePage().findView(BPELUNIT_COVERAGE_VIEW_ID);
    }

    public EclipseBPELUnitRunner getBPELUnitCore() throws IOException, URISyntaxException, ConfigurationException {
        if (this.fUnitCore == null) {
            this.fUnitCore = new EclipseBPELUnitRunner();
        }
        int globalTimeout = this.getPreferenceStore().getInt("globalTimeout");
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("GLOBAL_TIMEOUT", Integer.toString(globalTimeout));
        if (this.getPreferenceStore().getBoolean("CoverageMeasurment")) {
            options.put("MEASURE_COVERAGE", "true");
        }
        if (this.getPreferenceStore().getBoolean("EndpointModification")) {
            options.put("CHANGE_ENDPOINTS", "true");
        }
        this.fUnitCore.initialize(options);
        return this.fUnitCore;
    }

    public static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    private BPELUnitView getBPELUnitView() throws PartInitException {
        return (BPELUnitView)BPELUnitActivator.getActiveWorkbenchWindow().getActivePage().showView(BPELUNIT_VIEW_ID);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        reg.put(IMAGE_INFO, BPELUnitActivator.getImageDescriptor("icons/info_obj.gif"));
        reg.put(IMAGE_WARNING, BPELUnitActivator.getImageDescriptor("icons/warning_obj.gif"));
        reg.put(IMAGE_ERROR, BPELUnitActivator.getImageDescriptor("icons/error_obj.gif"));
        reg.put(IMAGE_BPEL, BPELUnitActivator.getImageDescriptor("icons/bpel.gif"));
    }

    public static Image getImage(String key) {
        return BPELUnitActivator.getDefault().getImageRegistry().get(key);
    }

    public void initializeCoverageResultView() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    BPELUnitCoverageResultView view = BPELUnitActivator.this.findBPELUnitCoverageView();
                    if (view != null) {
                        view.initialize();
                    }
                }
                catch (PartInitException e) {
                    BPELUnitActivator.log(e);
                    System.out.println("FEHLER " + e.getMessage());
                }
            }
        });
    }
}

