/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.ui.ant;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import net.bpelunit.framework.exception.ConfigurationException;
import net.bpelunit.framework.ui.ant.BPELUnitAntRunner;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class BPELUnit
extends Task {
    private String fBPELUnitDir = System.getenv("BPELUNIT_HOME");
    private boolean fHaltOnError;
    private boolean fHaltOnFailure;
    private List<Output> fOutputList = new ArrayList<Output>();
    private List<Logging> fLoggingList = new ArrayList<Logging>();
    private File fTestSuiteFile;

    public void execute() {
        this.checkAttributes();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("HALT_ON_ERROR", Boolean.toString(this.fHaltOnError));
        options.put("HALT_ON_FAILURE", Boolean.toString(this.fHaltOnFailure));
        BPELUnitAntRunner runner = new BPELUnitAntRunner(this.fBPELUnitDir, this.fLoggingList, this.fOutputList);
        try {
            runner.initialize(options);
            runner.run(this.fTestSuiteFile);
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }

    private void checkAttributes() {
        if (this.fTestSuiteFile == null) {
            throw new BuildException("The testsuite argument is required.");
        }
        if (!this.fTestSuiteFile.exists()) {
            throw new BuildException("The testsuite file does not exist.");
        }
        if (StringUtils.isEmpty((String)this.fBPELUnitDir)) {
            throw new BuildException("The BPELUnit directory is required - either specify an argument or set environment variable BPELUNIT_HOME.");
        }
        for (Output output : this.fOutputList) {
            if (output.hasValidStyle()) continue;
            throw new BuildException("An output specification is missing the style attribute, or wrong style specified.");
        }
        for (Logging logging : this.fLoggingList) {
            if (logging.hasValidLevel()) continue;
            throw new BuildException("A logging specification is missing the level attribute, or wrong level specified.");
        }
    }

    public void setTestSuite(String testSuite) {
        this.fTestSuiteFile = new File(testSuite);
    }

    public void setBPELUnitDir(String bpelUnitDir) {
        this.fBPELUnitDir = bpelUnitDir;
    }

    public void setHaltOnError(boolean haltOnError) {
        this.fHaltOnError = haltOnError;
    }

    public void setHaltOnFailure(boolean haltOnFailure) {
        this.fHaltOnFailure = haltOnFailure;
    }

    public void addConfiguredOutput(Output output) {
        this.fOutputList.add(output);
    }

    public void addConfiguredLogging(Logging logging) {
        this.fLoggingList.add(logging);
    }

    public static class Logging
    extends Extension {
        private String fLevel;

        public boolean hasValidLevel() {
            if (this.fLevel == null) {
                return false;
            }
            try {
                Level.parse(this.fLevel);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }

        public void setLevel(String type) {
            this.fLevel = type;
        }

        public String getLevel() {
            return this.fLevel;
        }

        public OutputStream getOutputStream() {
            return this.getOutput();
        }
    }

    public static class Extension {
        private String fFile;
        private OutputStream fOutput;

        public OutputStream getOutput() {
            return this.fOutput;
        }

        public void initialize() throws ConfigurationException {
            this.fOutput = this.createOutputStream();
        }

        public void dispose() {
            IOUtils.closeQuietly((OutputStream)this.fOutput);
        }

        private OutputStream createOutputStream() throws ConfigurationException {
            if (this.fFile != null) {
                String dir = FilenameUtils.getPath((String)this.fFile);
                if (!"".equals(dir)) {
                    new File(dir).mkdirs();
                }
                try {
                    return new FileOutputStream(this.fFile);
                }
                catch (FileNotFoundException e) {
                    throw new ConfigurationException("Cannot create file with name " + this.fFile + " for output.", (Throwable)e);
                }
            }
            return System.out;
        }

        public void write(String line) throws IOException {
            this.fOutput.write(line.getBytes());
        }

        public void setFile(String file) {
            this.fFile = file;
        }

        public String getFile() {
            return this.fFile;
        }
    }

    public static class Output
    extends Extension {
        public static final String STYLE_PLAIN = "PLAIN";
        public static final String STYLE_XML = "XML";
        private String fStyle;

        public String getStyle() {
            return this.fStyle;
        }

        public void setStyle(String style) {
            this.fStyle = style;
        }

        public boolean hasValidStyle() {
            return STYLE_PLAIN.equals(this.fStyle) || STYLE_XML.equals(this.fStyle);
        }
    }
}

