/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.verify;

import net.bpelunit.framework.exception.SpecificationException;
import net.bpelunit.framework.verify.NoCyclesInConditionGroupInheritanceValidator;
import net.bpelunit.framework.xml.suite.XMLConditionGroup;
import net.bpelunit.framework.xml.suite.XMLConditionGroupSection;
import net.bpelunit.framework.xml.suite.XMLTestSuite;
import net.bpelunit.framework.xml.suite.XMLTestSuiteDocument;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class NoCyclesInConditionGroupInheritanceValidatorTest {
    private NoCyclesInConditionGroupInheritanceValidator v = new NoCyclesInConditionGroupInheritanceValidator();
    private XMLTestSuiteDocument doc;
    private XMLTestSuite suite;
    private XMLConditionGroupSection cgs;

    @Before
    public void setUp() {
        this.doc = XMLTestSuiteDocument.Factory.newInstance();
        this.suite = this.doc.addNewTestSuite();
        this.cgs = this.suite.addNewConditionGroups();
    }

    @After
    public void tearDown() {
        this.doc = null;
        this.suite = null;
        this.cgs = null;
    }

    @Test
    public void testNoCycles() throws Exception {
        XMLConditionGroup cg = this.cgs.addNewConditionGroup();
        cg.setName("CG1");
        XMLConditionGroup cg2 = this.cgs.addNewConditionGroup();
        cg2.setName("CG2");
        cg2.setInheritFrom("CG1");
        this.v.validate(this.doc);
    }

    @Test(expected=SpecificationException.class)
    public void testSelfReference() throws SpecificationException {
        XMLConditionGroup cg = this.cgs.addNewConditionGroup();
        cg.setName("CG1");
        cg.setInheritFrom("CG1");
        this.v.validate(this.doc);
    }

    @Test(expected=SpecificationException.class)
    public void testCyclicReference() throws SpecificationException {
        XMLConditionGroup cg1 = this.cgs.addNewConditionGroup();
        cg1.setName("CG1");
        cg1.setInheritFrom("CG2");
        XMLConditionGroup cg2 = this.cgs.addNewConditionGroup();
        cg2.setName("CG2");
        cg2.setInheritFrom("CG1");
        this.v.validate(this.doc);
    }
}

