/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.control.ext;

import java.lang.reflect.Method;
import net.bpelunit.framework.control.ext.ExtensionRegistry;
import org.junit.Assert;
import org.junit.Test;

public class ExtensionRegistryTest {
    @Test
    public void testAnalyzeString() throws Exception {
        Assert.assertArrayEquals((Object[])new String[]{"a"}, (Object[])ExtensionRegistry.analyzeString((String)"a").toArray(new String[0]));
        Assert.assertArrayEquals((Object[])new String[]{"a", "b"}, (Object[])ExtensionRegistry.analyzeString((String)"a,b").toArray(new String[0]));
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c"}, (Object[])ExtensionRegistry.analyzeString((String)"a,b,c").toArray(new String[0]));
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c"}, (Object[])ExtensionRegistry.analyzeString((String)" a , b , c ").toArray(new String[0]));
    }

    @Test
    public void testIsStringSetter() throws Exception {
        Method method = TestBean.class.getMethod("setSomething", new Class[0]);
        Assert.assertFalse((boolean)ExtensionRegistry.isStringSetter((Method)method));
        method = TestBean.class.getMethod("something", String.class);
        Assert.assertFalse((boolean)ExtensionRegistry.isStringSetter((Method)method));
        method = TestBean.class.getMethod("setNotStringSomething", String.class);
        Assert.assertFalse((boolean)ExtensionRegistry.isStringSetter((Method)method));
        method = TestBean.class.getMethod("setStringSometing", String.class);
        Assert.assertTrue((boolean)ExtensionRegistry.isStringSetter((Method)method));
    }

    static class TestBean {
        TestBean() {
        }

        public void setSomething() {
        }

        public void setStringSometing(String s) {
        }

        public void something(String s) {
        }

        public String setNotStringSomething(String s) {
            return null;
        }
    }
}

