/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.model.test.data;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import net.bpelunit.framework.control.ext.ISOAPEncoder;
import net.bpelunit.framework.control.util.BPELUnitUtil;
import net.bpelunit.framework.exception.HeaderProcessingException;
import net.bpelunit.framework.exception.SOAPEncodingException;
import net.bpelunit.framework.exception.SpecificationException;
import net.bpelunit.framework.model.test.activity.Activity;
import net.bpelunit.framework.model.test.activity.ActivityContext;
import net.bpelunit.framework.model.test.activity.VelocityContextProvider;
import net.bpelunit.framework.model.test.data.ContextXPathVariableResolver;
import net.bpelunit.framework.model.test.data.DataCopyOperation;
import net.bpelunit.framework.model.test.data.DataSpecification;
import net.bpelunit.framework.model.test.data.ReceiveCondition;
import net.bpelunit.framework.model.test.data.SOAPOperationCallIdentifier;
import net.bpelunit.framework.model.test.data.XMLData;
import net.bpelunit.framework.model.test.report.ArtefactStatus;
import net.bpelunit.framework.model.test.report.ITestArtefact;
import net.bpelunit.framework.model.test.report.StateData;
import org.apache.velocity.context.Context;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReceiveDataSpecification
extends DataSpecification {
    private SOAPOperationCallIdentifier fOperation;
    private String fEncodingStyle;
    private ISOAPEncoder fDecoder;
    private String fPlainMessage;
    private SOAPMessage fSOAPMessage;
    private Element fLiteralData;
    private List<ReceiveCondition> fConditions;
    private QName fFaultCode;
    private String fFaultString;

    public ReceiveDataSpecification(Activity parent, NamespaceContext nsContext) throws SpecificationException {
        super(parent, nsContext);
    }

    public void initialize(SOAPOperationCallIdentifier op, String encodingStyle, ISOAPEncoder encoder, List<ReceiveCondition> conditions, QName faultCode, String faultString) throws SpecificationException {
        this.fOperation = op;
        this.fConditions = conditions;
        this.fDecoder = encoder;
        this.fEncodingStyle = encodingStyle;
        this.fFaultCode = faultCode;
        this.fFaultString = faultString;
    }

    public void handle(ActivityContext context, String incomingMessage) {
        this.setInWireFormat(incomingMessage);
        if (this.hasProblems()) {
            return;
        }
        try {
            context.processHeaders(this);
        }
        catch (HeaderProcessingException e) {
            this.setStatus(ArtefactStatus.createErrorStatus("Header Processing Fault.", e));
            return;
        }
        if (this.hasProblems()) {
            return;
        }
        this.decodeMessage();
        if (this.hasProblems()) {
            return;
        }
        this.extractMappingData(context);
        if (this.hasProblems()) {
            return;
        }
        context.saveReceivedMessage(this.fLiteralData);
        this.validateConditions(context);
        if (this.hasProblems()) {
            return;
        }
        this.setStatus(ArtefactStatus.createPassedStatus());
    }

    public SOAPMessage getSOAPMessage() {
        return this.fSOAPMessage;
    }

    private void setInWireFormat(String body) {
        try {
            this.fPlainMessage = body;
            MessageFactory factory = MessageFactory.newInstance();
            this.fSOAPMessage = factory.createMessage(null, (InputStream)new ByteArrayInputStream(body.getBytes()));
        }
        catch (Exception e) {
            this.setStatus(ArtefactStatus.createErrorStatus("Could not create SOAP message from incoming message: " + e.getMessage(), e));
        }
    }

    private void decodeMessage() {
        try {
            this.fLiteralData = this.fDecoder.deconstruct(this.fOperation, this.fSOAPMessage);
        }
        catch (SOAPEncodingException e) {
            this.setStatus(ArtefactStatus.createErrorStatus("Not able to deconstruct incoming message into SOAP Message: " + e.getMessage(), e));
        }
    }

    private void validateConditions(VelocityContextProvider templateContext) {
        Context conditionContext;
        SOAPBody body;
        try {
            body = this.fSOAPMessage.getSOAPBody();
        }
        catch (SOAPException e) {
            this.setStatus(ArtefactStatus.createErrorStatus("Exception during condition validation", (Exception)((Object)e)));
            return;
        }
        if (this.fOperation.isFault()) {
            SOAPFault fault = body.getFault();
            if (fault == null) {
                this.setStatus(ArtefactStatus.createFailedStatus("A fault was expected in operation " + this + ", but none was found in input data."));
                return;
            }
            if (this.fFaultCode != null && !this.fFaultCode.equals(fault.getFaultCodeAsQName())) {
                this.setStatus(ArtefactStatus.createFailedStatus(String.format("Expected the fault code %s, got %s instead", this.fFaultCode, fault.getFaultCodeAsQName())));
                return;
            }
            if (this.fFaultString != null && !this.fFaultString.equals(fault.getFaultString())) {
                this.setStatus(ArtefactStatus.createFailedStatus(String.format("Expected the fault string %s, got %s instead", this.fFaultString, fault.getFaultString())));
                return;
            }
        } else if (body.getFault() != null) {
            this.setStatus(ArtefactStatus.createFailedStatus("The operation " + this + " was expected to succeed, but replied with a SOAP fault."));
            return;
        }
        try {
            conditionContext = templateContext.createVelocityContext();
        }
        catch (Exception e) {
            this.setStatus(ArtefactStatus.createFailedStatus(String.format("Could not create the Velocity context for this condition: %s", e.getLocalizedMessage())));
            return;
        }
        ContextXPathVariableResolver variableResolver = new ContextXPathVariableResolver(conditionContext);
        for (ReceiveCondition c : this.fConditions) {
            c.evaluate(templateContext, this.fLiteralData, this.getNamespaceContext(), variableResolver);
            if (c.isFailure()) {
                if (this.getStatus().isError()) continue;
                this.setStatus(ArtefactStatus.createFailedStatus(String.format("Condition '%s=%s' did not hold: %s", c.getExpression(), c.getExpectedValue(), c.getStatus().getMessage())));
                continue;
            }
            if (!c.isError()) continue;
            this.setStatus(ArtefactStatus.createErrorStatus(String.format("Condition '%s=%s' had an error: %s.", c.getExpression(), c.getExpectedValue(), c.getStatus().getMessage())));
        }
    }

    private void extractMappingData(ActivityContext context) {
        List<DataCopyOperation> mapping = context.getMapping();
        if (mapping != null) {
            for (DataCopyOperation copy : mapping) {
                copy.retrieveTextNodes(this.fLiteralData, this.getNamespaceContext());
                if (!copy.isError()) continue;
                this.setStatus(ArtefactStatus.createErrorStatus("An error occurred while evaluating Copy-From-XPath expression."));
                return;
            }
        }
    }

    private String getWireFormatAsString() {
        if (this.fPlainMessage != null) {
            return this.fPlainMessage;
        }
        return "(no data)";
    }

    private String getLiteralDataAsString() {
        if (this.fLiteralData != null) {
            return BPELUnitUtil.toFormattedString(this.fLiteralData.getOwnerDocument());
        }
        return "(no data)";
    }

    private String getSOAPMessageDataAsString() {
        if (this.fSOAPMessage != null) {
            return BPELUnitUtil.toFormattedString((Document)this.fSOAPMessage.getSOAPPart());
        }
        return "(no message)";
    }

    @Override
    public String getName() {
        return "Receive Data Package";
    }

    @Override
    public List<ITestArtefact> getChildren() {
        ArrayList<ITestArtefact> returner = new ArrayList<ITestArtefact>();
        for (ReceiveCondition c : this.fConditions) {
            returner.add(c);
        }
        returner.add(new XMLData(this, "Plain incoming message", this.getWireFormatAsString()));
        returner.add(new XMLData(this, "SOAP Message data", this.getSOAPMessageDataAsString()));
        returner.add(new XMLData(this, "Literal XML data", this.getLiteralDataAsString()));
        return returner;
    }

    @Override
    public List<StateData> getStateData() {
        ArrayList<StateData> stateData = new ArrayList<StateData>();
        stateData.addAll(this.getStatus().getAsStateData());
        stateData.add(new StateData("Style/Encoding", this.fEncodingStyle));
        stateData.add(new StateData("Direction", this.fOperation.getDirection().name()));
        return stateData;
    }
}

